package yangtz.cs.liu.campus.controller.interest;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.interest.SchoolInterestClassesDetails;
import yangtz.cs.liu.campus.service.interest.ISchoolInterestClassesDetailsService;
import yangtz.cs.liu.campus.vo.interest.DetailsVO;

/**
 * 兴趣班详情Controller
 *
 * @author ruoyi
 * @date 2022-10-04
 */
@RestController
@RequestMapping("/interestDetails")
public class SchoolInterestClassesDetailsController extends BaseController {
    @Autowired
    private ISchoolInterestClassesDetailsService schoolInterestClassesDetailsService;

    /**
     * 查询兴趣班详情列表
     */
    @GetMapping("/list/{interestClassesId}")
    public TableDataInfo list(@PathVariable Long interestClassesId, SchoolInterestClassesDetails details) {
        startPage();
        details.setInterestClassesId(interestClassesId);
        List<DetailsVO> list = schoolInterestClassesDetailsService.queryList(details);
        return getDataTable(list);
    }

    /**
     * 获取兴趣班详情详细信息
     */
    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(schoolInterestClassesDetailsService.getById(id));
    }

    /**
     * 新增兴趣班详情
     */
    @PostMapping("/add/{interestClassesId}")
    public AjaxResult add(@RequestBody @Validated SchoolInterestClassesDetails schoolInterestClassesDetails, @PathVariable Long interestClassesId) {
        schoolInterestClassesDetails.setInterestClassesId(interestClassesId);
        return toAjax(schoolInterestClassesDetailsService.save(schoolInterestClassesDetails));
    }

    /**
     * 修改兴趣班详情
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolInterestClassesDetails schoolInterestClassesDetails) {
        if (StringUtils.isNull(schoolInterestClassesDetails.getId())) {
            throw new ServiceException("id为空，修改失败");
        }
        return toAjax(schoolInterestClassesDetailsService.updateById(schoolInterestClassesDetails));
    }

    /**
     * 删除兴趣班详情
     */
    @DeleteMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable List<Long> ids) {
        return toAjax(schoolInterestClassesDetailsService.removeByIds(ids));
    }

    /**
     * 导出全部
     */
    @PostMapping("/exportAll/{interestClassesId}")
    public void export(HttpServletResponse response, @PathVariable Long interestClassesId, SchoolInterestClassesDetails schoolInterestClassesDetails) {
        schoolInterestClassesDetails.setInterestClassesId(interestClassesId);
        List<DetailsVO> list = schoolInterestClassesDetailsService.queryList(schoolInterestClassesDetails);
        ExcelUtil<DetailsVO> util = new ExcelUtil<DetailsVO>(DetailsVO.class);
        util.exportExcel(response, list, "兴趣班详情数据");
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<SchoolInterestClassesDetails> list = schoolInterestClassesDetailsService.listByIds(ids);
        ExcelUtil<SchoolInterestClassesDetails> util = new ExcelUtil<>(SchoolInterestClassesDetails.class);
        util.exportExcel(response, list, "兴趣班详情数据");
    }
}
