package yangtz.cs.liu.campus.controller.interest;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.interest.SchoolInterestClassesAttendance;
import yangtz.cs.liu.campus.service.interest.ISchoolInterestClassesAttendanceService;
import yangtz.cs.liu.campus.vo.interest.AttendanceVO;

/**
 * 兴趣班考勤信息Controller
 * 
 * @author ruoyi
 * @date 2022-10-09
 */
@RestController
@RequestMapping("/interestAttendance")
public class SchoolInterestClassesAttendanceController extends BaseController
{
    @Autowired
    private ISchoolInterestClassesAttendanceService schoolInterestClassesAttendanceService;

    /**
     * 查询兴趣班考勤信息列表
     */
    @GetMapping("/list/{interestClassesId}")
    public TableDataInfo list(SchoolInterestClassesAttendance schoolInterestClassesAttendance,@PathVariable Long interestClassesId)
    {
        startPage();
        List<AttendanceVO> list = schoolInterestClassesAttendanceService.queryList(schoolInterestClassesAttendance,interestClassesId);
        return getDataTable(list);
    }

    /**
     * 导出兴趣班考勤信息列表
     */
    @PreAuthorize("@ss.hasPermi('system:attendance:export')")
    @Log(title = "兴趣班考勤信息", businessType = BusinessType.EXPORT)
    @PostMapping("/exportAll/{interestClassesId}")
    public void export(HttpServletResponse response, @PathVariable Long interestClassesId, SchoolInterestClassesAttendance schoolInterestClassesAttendance)
    {
        List<AttendanceVO> list = schoolInterestClassesAttendanceService.queryList(schoolInterestClassesAttendance,interestClassesId);
        ExcelUtil<AttendanceVO> util = new ExcelUtil<AttendanceVO>(AttendanceVO.class);
        util.exportExcel(response, list, "兴趣班考勤信息数据");
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<SchoolInterestClassesAttendance> list = schoolInterestClassesAttendanceService.listByIds(ids);
        ExcelUtil<SchoolInterestClassesAttendance> util = new ExcelUtil<>(SchoolInterestClassesAttendance.class);
        util.exportExcel(response, list, "兴趣班考勤信息数据");
    }

    /**
     * 获取兴趣班考勤信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:attendance:query')")
    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
       // return AjaxResult.success(schoolInterestClassesAttendanceService.getById(id));
        return AjaxResult.success(schoolInterestClassesAttendanceService.getInfo(id));
    }

    /**
     * 新增兴趣班考勤信息
     */
    @PreAuthorize("@ss.hasPermi('system:attendance:add')")
    @Log(title = "兴趣班考勤信息", businessType = BusinessType.INSERT)
    @PostMapping("/add/{interestClassesId}")
    public AjaxResult add(@RequestBody @Validated SchoolInterestClassesAttendance schoolInterestClassesAttendance, @PathVariable Long interestClassesId)
    {
        schoolInterestClassesAttendance.setInterestClassesId(interestClassesId);
        return toAjax(schoolInterestClassesAttendanceService.save(schoolInterestClassesAttendance));
    }

    /**
     * 修改兴趣班考勤信息
     */
    @Log(title = "兴趣班考勤信息", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolInterestClassesAttendance schoolInterestClassesAttendance)
    {
        if (StringUtils.isNull(schoolInterestClassesAttendance.getId())) {
            throw new ServiceException("id为空，修改失败");
        }
        return toAjax(schoolInterestClassesAttendanceService.updateById(schoolInterestClassesAttendance));
    }

    /**
     * 删除兴趣班考勤信息
     */
    @PreAuthorize("@ss.hasPermi('system:attendance:remove')")
    @Log(title = "兴趣班考勤信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable List<Long> ids)
    {
        return toAjax(schoolInterestClassesAttendanceService.removeByIds(ids));
    }
}
