package yangtz.cs.liu.campus.controller.fudao;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.service.ISysDeptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.fudao.FudaoTeacher;
import yangtz.cs.liu.campus.service.fudao.FudaoTeacherService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXteachingAchievementsService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.SchoolTeacherBasichlnformationService;
import yangtz.cs.liu.campus.vo.fudao.FudaoStudentVo;
import yangtz.cs.liu.campus.vo.fudao.FudaoTeacherVo;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/school/fudaot")
public class FudaoTeacherController extends BaseController {

    @Autowired
    private FudaoTeacherService fudaoTeacherService;
    @Autowired
    private ISchoolXteachingAchievementsService schoolXteachingAchievementsService;
    @Autowired
    private ISysDeptService sysDeptService;
    @Autowired
    private SchoolTeacherBasichlnformationService basichlnformationService;


    //查询辅导教师获奖列表
//    @PreAuthorize("@ss.hasPermi('school:fudaot:teacher')")
    @GetMapping("/teacher")
    public TableDataInfo list(FudaoTeacherVo fudaoTeacherVo){
        //过滤未提交的数据
        fudaoTeacherVo.setAuditstate("0");
        //获取当前登陆人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取当前登陆人的角色信息
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()) {
            startPage();
            List<FudaoTeacherVo> list = fudaoTeacherService.querylist(fudaoTeacherVo);
            list.forEach(list1 -> {
                list1.setGrowthType("教师获奖");
            });
            return getDataTable(list);
        }

        //全部权限
        List<SysRole> roleList = roles.stream().filter(role -> role.getRoleKey().equals("jsdzdncj_admin") || role.getRoleKey().equals("fdjshj_admin")).collect(Collectors.toList());
        if (roleList.size() > 0){
            startPage();
            List<FudaoTeacherVo> list = fudaoTeacherService.querylist(fudaoTeacherVo);
            list.forEach(list1 -> {
                list1.setGrowthType("教师获奖");
            });
            return getDataTable(list);
        }

        //部分权限
        List<SysRole> roleList1 = roles.stream().filter(role -> role.getRoleKey().equals("jsdnzj_admin")).collect(Collectors.toList());
        //查询是否包含学科组长角色
        List<SysRole> roleList2 = roles.stream().filter(role -> role.getRoleKey().equals("sub_leader")).collect(Collectors.toList());
        if (roleList1.size() > 0){
            //教师电子档案中级管理员只能查看本部门及部门以下的数据
            //根据用户部门id查询用户部门信息
            SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
            //查询本部门下所有教师的id
            List<Long> deptUserIds = schoolXteachingAchievementsService.getUserIdsByDeptId(sysDept.getDeptId());
            if (deptUserIds.size() > 0){
                fudaoTeacherVo.setUserids(deptUserIds);
            }
            if (roleList2.size() > 0){
                //根据当前登陆人手机号查询任教学科
                String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                fudaoTeacherVo.setSub1(sub);
            }
            startPage();
            List<FudaoTeacherVo> list = fudaoTeacherService.querylist(fudaoTeacherVo);
            list.forEach(list1 -> {
                list1.setGrowthType("教师获奖");
            });
            return getDataTable(list);
        }
        if (roleList2.size() > 0){
            //根据当前登陆人手机号查询任教学科
            String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
            fudaoTeacherVo.setSub1(sub);
            startPage();
            List<FudaoTeacherVo> list = fudaoTeacherService.querylist(fudaoTeacherVo);
            list.forEach(list1 -> {
                list1.setGrowthType("教师获奖");
            });
            return getDataTable(list);
        }
        return getDataTable(new ArrayList<>());
    }

    //查询辅导教师获奖列表(个人)
//    @PreAuthorize("@ss.hasPermi('school:fudaot:teacherGr')")
    @GetMapping("/teacherGr")
    public TableDataInfo listGr(FudaoTeacherVo fudaoTeacherVo){
        fudaoTeacherVo.setUserid(SecurityUtils.getUserId());
        startPage();
        List<FudaoTeacherVo> list = fudaoTeacherService.querylist(fudaoTeacherVo);
        list.forEach(list1 -> {
            list1.setGrowthType("教师获奖");
        });
        return getDataTable(list);
    }

    /**
     * 查询详情
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public AjaxResult selectT(@PathVariable Long id){
        return AjaxResult.success(fudaoTeacherService.selectTutorAwardById(id));
    }


    //新增辅导教师获奖（管理员）
//    @PreAuthorize("@ss.hasPermi('school:fudaot:addgl')")
    @PostMapping("/addgl")
    public AjaxResult addgl(@RequestBody FudaoTeacher fudaoTeacher){
        fudaoTeacher.setAuditstate("2");
        return toAjax(fudaoTeacherService.insert(fudaoTeacher));
    }

    // 新增辅导教师获奖(个人)
//    @PreAuthorize("@ss.hasPermi('school:fudaot:add')")
    @PostMapping("/add")
    public AjaxResult add(@RequestBody FudaoTeacher fudaoTeacher){
        return toAjax(fudaoTeacherService.insert(fudaoTeacher));
    }

    //删除
//    @PreAuthorize("@ss.hasPermi('school:fudaot:delete')")
    @DeleteMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids){
        return toAjax(fudaoTeacherService.delete(ids));
    }

    //修改
//    @PreAuthorize("@ss.hasPermi('school:fudaot:edit')")
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody FudaoTeacher fudaoTeacher){
        return toAjax(fudaoTeacherService.updatefudao(fudaoTeacher));
    }

    //导出
//    @PreAuthorize("@ss.hasPermi('school:fudaot:export')")
    @PostMapping("/export")
    public void export(HttpServletResponse response, FudaoTeacherVo fudaoTeacherVo) {
        int i = 0;
        //过滤未提交的数据
        fudaoTeacherVo.setAuditstate("0");
        //获取当前登陆人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取当前登陆人的角色信息
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()) {
            List<FudaoTeacherVo> list = fudaoTeacherService.querylist(fudaoTeacherVo);
            for (FudaoTeacherVo teacherVo : list) {
                i ++;
                teacherVo.setXh(i);
                teacherVo.setGrowthType("辅导教师获奖");
            }
            ExcelUtil<FudaoTeacherVo> util = new ExcelUtil<FudaoTeacherVo>(FudaoTeacherVo.class);
            util.exportExcel(response, list, "辅导教师获奖");
        }else {
            //全部权限
            List<SysRole> roleList = roles.stream().filter(role -> role.getRoleKey().equals("jsdzdncj_admin") || role.getRoleKey().equals("fdjshj_admin")).collect(Collectors.toList());
            if (roleList.size() > 0){
                List<FudaoTeacherVo> list = fudaoTeacherService.querylist(fudaoTeacherVo);
                for (FudaoTeacherVo teacherVo : list) {
                    i ++;
                    teacherVo.setXh(i);
                    teacherVo.setGrowthType("辅导教师获奖");
                }
                ExcelUtil<FudaoTeacherVo> util = new ExcelUtil<FudaoTeacherVo>(FudaoTeacherVo.class);
                util.exportExcel(response, list, "辅导教师获奖");
            }else {
                //部分权限
                List<SysRole> roleList1 = roles.stream().filter(role -> role.getRoleKey().equals("jsdnzj_admin")).collect(Collectors.toList());
                //查询是否包含学科组长角色
                List<SysRole> roleList2 = roles.stream().filter(role -> role.getRoleKey().equals("sub_leader")).collect(Collectors.toList());
                if (roleList1.size() > 0){
                    //教师电子档案中级管理员只能查看本部门及部门以下的数据
                    //根据用户部门id查询用户部门信息
                    SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
                    //查询本部门下所有教师的id
                    List<Long> deptUserIds = schoolXteachingAchievementsService.getUserIdsByDeptId(sysDept.getDeptId());
                    if (deptUserIds.size() > 0){
                        fudaoTeacherVo.setUserids(deptUserIds);
                    }
                    if (roleList2.size() > 0){
                        //根据当前登陆人手机号查询任教学科
                        String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                        fudaoTeacherVo.setSub1(sub);
                    }
                    List<FudaoTeacherVo> list = fudaoTeacherService.querylist(fudaoTeacherVo);
                    for (FudaoTeacherVo teacherVo : list) {
                        i ++;
                        teacherVo.setXh(i);
                        teacherVo.setGrowthType("辅导教师获奖");
                    }
                    ExcelUtil<FudaoTeacherVo> util = new ExcelUtil<FudaoTeacherVo>(FudaoTeacherVo.class);
                    util.exportExcel(response, list, "辅导教师获奖");
                }else {
                    if (roleList2.size() > 0){
                        //根据当前登陆人手机号查询任教学科
                        String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                        fudaoTeacherVo.setSub1(sub);
                        List<FudaoTeacherVo> list = fudaoTeacherService.querylist(fudaoTeacherVo);
                        for (FudaoTeacherVo teacherVo : list) {
                            i ++;
                            teacherVo.setXh(i);
                            teacherVo.setGrowthType("辅导教师获奖");
                        }
                        ExcelUtil<FudaoTeacherVo> util = new ExcelUtil<FudaoTeacherVo>(FudaoTeacherVo.class);
                        util.exportExcel(response, list, "辅导教师获奖");
                    }else {
                        ExcelUtil<FudaoTeacherVo> util = new ExcelUtil<FudaoTeacherVo>(FudaoTeacherVo.class);
                        util.exportExcel(response, new ArrayList<>(), "辅导教师获奖");
                    }
                }
            }
        }
    }

    //导出(个人)
//    @PreAuthorize("@ss.hasPermi('school:fudaot:exportGr')")
    @PostMapping("/exportGr")
    public void exportGr(HttpServletResponse response, FudaoTeacherVo fudaoTeacherVo) {
        int i = 0;
        fudaoTeacherVo.setUserid(SecurityUtils.getUserId());
        List<FudaoTeacherVo> list = fudaoTeacherService.querylist(fudaoTeacherVo);
        for (FudaoTeacherVo teacherVo : list) {
            i ++;
            teacherVo.setXh(i);
            teacherVo.setGrowthType("辅导教师获奖");
        }
        ExcelUtil<FudaoTeacherVo> util = new ExcelUtil<FudaoTeacherVo>(FudaoTeacherVo.class);
        util.exportExcel(response, list, "辅导教师获奖");
    }

    //审核
//    @PreAuthorize("@ss.hasPermi('school:fudaot:submit')")
    @PutMapping("/submit")
    public AjaxResult submit(@RequestBody FudaoTeacher fudaoTeacher)
    {
        return toAjax(fudaoTeacherService.submit(fudaoTeacher));
    }
}
