package yangtz.cs.liu.campus.controller.fudao;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.core.domain.entity.SysRole;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.service.ISysDeptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.fudao.FudaoStudent;
import yangtz.cs.liu.campus.domain.schoolNewTeacherDzdn.SchoolGkAchievementVo;
import yangtz.cs.liu.campus.service.fudao.FudaoStudentService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.ISchoolXteachingAchievementsService;
import yangtz.cs.liu.campus.service.schoolNewTeacherDzdn.SchoolTeacherBasichlnformationService;
import yangtz.cs.liu.campus.vo.fudao.FudaoStudentVo;
import yangtz.cs.liu.campus.vo.fudao.FudaoTeacherVo;
import yangtz.cs.liu.campus.vo.schoolNewTeacherDzdn.SchoolXteacherAwardsVo;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;


@RestController
@RequestMapping("/school/fudaos")
public class FudaoStudentController extends BaseController {

    @Autowired
    private FudaoStudentService fudaoStudentService;
    @Autowired
    private ISchoolXteachingAchievementsService schoolXteachingAchievementsService;
    @Autowired
    private ISysDeptService sysDeptService;
    @Autowired
    private SchoolTeacherBasichlnformationService basichlnformationService;


    //查询辅导学生获奖列表
//    @PreAuthorize("@ss.hasPermi('school:fudaos:studentlist')")
    @GetMapping("/studentlist")
    public TableDataInfo list(FudaoStudentVo fudaoStudentVo){
        //过滤未提交的数据
        fudaoStudentVo.setAuditstate("0");

        //获取当前登陆人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取当前登陆人的角色信息
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()) {
            startPage();
            List<FudaoStudentVo> list = fudaoStudentService.querylist(fudaoStudentVo);
            list.forEach(list1 -> {
                list1.setGrowthType("学生获奖");
            });
            return getDataTable(list);
        }
        //全部权限
        List<SysRole> roleList = roles.stream().filter(role -> role.getRoleKey().equals("jsdzdncj_admin") || role.getRoleKey().equals("fdxshj_admin")).collect(Collectors.toList());
        if (roleList.size() > 0){
            startPage();
            List<FudaoStudentVo> list = fudaoStudentService.querylist(fudaoStudentVo);
            list.forEach(list1 -> {
                list1.setGrowthType("学生获奖");
            });
            return getDataTable(list);
        }
        //部分权限
        List<SysRole> roleList1 = roles.stream().filter(role -> role.getRoleKey().equals("jsdnzj_admin")).collect(Collectors.toList());
        //查询是否包含学科组长角色
        List<SysRole> roleList2 = roles.stream().filter(role -> role.getRoleKey().equals("sub_leader")).collect(Collectors.toList());
        if (roleList1.size() > 0){
            //教师电子档案中级管理员只能查看本部门及部门以下的数据
            //根据用户部门id查询用户部门信息
            SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
            //查询本部门下所有教师的id
            List<Long> deptUserIds = schoolXteachingAchievementsService.getUserIdsByDeptId(sysDept.getDeptId());
            if (deptUserIds.size() > 0){
                fudaoStudentVo.setUserids(deptUserIds);
            }
            if (roleList2.size() > 0){
                //根据当前登陆人手机号查询任教学科
                String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                fudaoStudentVo.setSub1(sub);
            }
            startPage();
            List<FudaoStudentVo> list = fudaoStudentService.querylist(fudaoStudentVo);
            list.forEach(list1 -> {
                list1.setGrowthType("学生获奖");
            });
            return getDataTable(list);
        }
        if (roleList2.size() > 0){
            //根据当前登陆人手机号查询任教学科
            String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
            fudaoStudentVo.setSub1(sub);
            startPage();
            List<FudaoStudentVo> list = fudaoStudentService.querylist(fudaoStudentVo);
            list.forEach(list1 -> {
                list1.setGrowthType("学生获奖");
            });
            return getDataTable(list);
        }
        return getDataTable(new ArrayList<>());
    }

    //查询辅导学生获奖列表(个人)
//    @PreAuthorize("@ss.hasPermi('school:fudaos:studentlistGr')")
    @GetMapping("/studentlistGr")
    public TableDataInfo listGr(FudaoStudentVo fudaoStudentVo){
        fudaoStudentVo.setUserid(SecurityUtils.getUserId());
        startPage();
        List<FudaoStudentVo> list = fudaoStudentService.querylist(fudaoStudentVo);
        list.forEach(list1 -> {
            list1.setGrowthType("学生获奖");
        });
        return getDataTable(list);
    }

    /**
     * 查看详情
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public AjaxResult getInfo(@PathVariable Long id){
        return AjaxResult.success(fudaoStudentService.selectTutorStudentById(id));
    }

    //新增辅导学生获奖（管理）
//    @PreAuthorize("@ss.hasPermi('school:fudaos:addgl')")
    @PostMapping("/addgl")
    public AjaxResult addgl(@RequestBody FudaoStudent fudaoStudent){
        fudaoStudent.setAuditstate("2");
        return toAjax(fudaoStudentService.insert(fudaoStudent));
    }

    // 新增辅导学生获奖（个人）
//    @PreAuthorize("@ss.hasPermi('school:fudaos:add')")
    @PostMapping("/add")
    public AjaxResult add(@RequestBody FudaoStudent fudaoStudent){
        return toAjax(fudaoStudentService.insert(fudaoStudent));
    }

    //删除
//    @PreAuthorize("@ss.hasPermi('school:fudaos:delete')")
    @DeleteMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids){
        return toAjax(fudaoStudentService.delete(ids));
    }

    //修改
//    @PreAuthorize("@ss.hasPermi('school:fudaos:edit')")
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody FudaoStudent fudaoStudent){
        return toAjax(fudaoStudentService.updatefudao(fudaoStudent));
    }


    //导出
//    @PreAuthorize("@ss.hasPermi('school:fudaos:export')")
    @PostMapping("/export")
    public void export(HttpServletResponse response, FudaoStudentVo fudaoStudentVo) {
        int i = 0;
        fudaoStudentVo.setAuditstate("0");

        //获取当前登陆人信息
        SysUser user = SecurityUtils.getLoginUser().getUser();
        //获取当前登陆人的角色信息
        List<SysRole> roles = user.getRoles();
        if (user.isAdmin()) {
            List<FudaoStudentVo> list = fudaoStudentService.querylist(fudaoStudentVo);
            for (FudaoStudentVo studentVo : list) {
                i++;
                studentVo.setXh(i);
                studentVo.setGrowthType("学生获奖");
            }
            ExcelUtil<FudaoStudentVo> util = new ExcelUtil<FudaoStudentVo>(FudaoStudentVo.class);
            util.exportExcel(response, list, "辅导学生获奖");
        }else {
            //全部权限
            List<SysRole> roleList = roles.stream().filter(role -> role.getRoleKey().equals("jsdzdncj_admin") || role.getRoleKey().equals("fdxshj_admin")).collect(Collectors.toList());
            if (roleList.size() > 0){
                List<FudaoStudentVo> list = fudaoStudentService.querylist(fudaoStudentVo);
                for (FudaoStudentVo studentVo : list) {
                    i++;
                    studentVo.setXh(i);
                    studentVo.setGrowthType("学生获奖");
                }
                ExcelUtil<FudaoStudentVo> util = new ExcelUtil<FudaoStudentVo>(FudaoStudentVo.class);
                util.exportExcel(response, list, "辅导学生获奖");
            }else {
                //部分权限
                List<SysRole> roleList1 = roles.stream().filter(role -> role.getRoleKey().equals("jsdnzj_admin")).collect(Collectors.toList());
                //查询是否包含学科组长角色
                List<SysRole> roleList2 = roles.stream().filter(role -> role.getRoleKey().equals("sub_leader")).collect(Collectors.toList());
                if (roleList1.size() > 0){
                    //教师电子档案中级管理员只能查看本部门及部门以下的数据
                    //根据用户部门id查询用户部门信息
                    SysDept sysDept = sysDeptService.selectDeptById(user.getDeptId());
                    //查询本部门下所有教师的id
                    List<Long> deptUserIds = schoolXteachingAchievementsService.getUserIdsByDeptId(sysDept.getDeptId());
                    if (deptUserIds.size() > 0){
                        fudaoStudentVo.setUserids(deptUserIds);
                    }
                    if (roleList2.size() > 0){
                        //根据当前登陆人手机号查询任教学科
                        String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                        fudaoStudentVo.setSub1(sub);
                    }
                    List<FudaoStudentVo> list = fudaoStudentService.querylist(fudaoStudentVo);
                    for (FudaoStudentVo studentVo : list) {
                        i++;
                        studentVo.setXh(i);
                        studentVo.setGrowthType("学生获奖");
                    }
                    ExcelUtil<FudaoStudentVo> util = new ExcelUtil<FudaoStudentVo>(FudaoStudentVo.class);
                    util.exportExcel(response, list, "辅导学生获奖");
                }else {
                    if (roleList2.size() > 0){
                        //根据当前登陆人手机号查询任教学科
                        String sub = basichlnformationService.selectSubByDdPhone(user.getPhonenumber());
                        fudaoStudentVo.setSub1(sub);
                        List<FudaoStudentVo> list = fudaoStudentService.querylist(fudaoStudentVo);
                        for (FudaoStudentVo studentVo : list) {
                            i++;
                            studentVo.setXh(i);
                            studentVo.setGrowthType("学生获奖");
                        }
                        ExcelUtil<FudaoStudentVo> util = new ExcelUtil<FudaoStudentVo>(FudaoStudentVo.class);
                        util.exportExcel(response, list, "辅导学生获奖");
                    }else {
                        ExcelUtil<FudaoStudentVo> util = new ExcelUtil<FudaoStudentVo>(FudaoStudentVo.class);
                        util.exportExcel(response, new ArrayList<>(), "辅导学生获奖");
                    }
                }
            }
        }
    }

    //导出(个人)
//    @PreAuthorize("@ss.hasPermi('school:fudaos:exportGr')")
    @PostMapping("/exportGr")
    public void exportGr(HttpServletResponse response, FudaoStudentVo fudaoStudentVo) {
        int i = 0;
        fudaoStudentVo.setUserid(SecurityUtils.getUserId());
        List<FudaoStudentVo> list = fudaoStudentService.querylist(fudaoStudentVo);
        for (FudaoStudentVo studentVo : list) {
            i++;
            studentVo.setXh(i);
            studentVo.setGrowthType("学生获奖");
        }
        ExcelUtil<FudaoStudentVo> util = new ExcelUtil<FudaoStudentVo>(FudaoStudentVo.class);
        util.exportExcel(response, list, "辅导学生获奖");
    }


    //审核
//    @PreAuthorize("@ss.hasPermi('school:fudaos:submit')")
    @PutMapping("/submit")
    public AjaxResult submit(@RequestBody FudaoStudent fudaoStudent)
    {
        return toAjax(fudaoStudentService.submit(fudaoStudent));
    }

}
