package yangtz.cs.liu.campus.controller.examination;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;

import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.examination.SchoolTestProject;
import yangtz.cs.liu.campus.service.examination.ISchoolTestProjectService;

/**
 * 测试项目Controller
 *
 * @author wengxiulin
 * @date 2023-04-11
 */
@RestController
@RequestMapping("/schoolTestProject")
public class SchoolTestProjectController extends BaseController
{
    @Autowired
    private ISchoolTestProjectService schoolTestProjectService;

    /**
     * 查询测试项目列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolTestProject schoolTestProject)
    {
//        startPage();
        List<SchoolTestProject> list = schoolTestProjectService.selectSchoolTestProjectList(schoolTestProject);
        return getDataTable(list);
    }

    /**
     * 导出测试项目列表
     */
    @Log(title = "examination", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolTestProject schoolTestProject)
    {
        List<SchoolTestProject> list = schoolTestProjectService.selectSchoolTestProjectList(schoolTestProject);
        ExcelUtil<SchoolTestProject> util = new ExcelUtil<SchoolTestProject>(SchoolTestProject.class);
        util.exportExcel(response, list, "examination数据");
    }

    /**
     * 获取测试项目详细信息
     */
    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolTestProjectService.getById(id));
    }

    /**
     * 新增测试项目
     */
    @Log(title = "examination", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolTestProject schoolTestProject)
    {
        schoolTestProject.insert();
        return toAjax(schoolTestProjectService.save(schoolTestProject));
    }

    /**
     * 修改测试项目
     */
    @Log(title = "examination", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolTestProject schoolTestProject)
    {
        if (StringUtils.isNull(schoolTestProject.getId())){
            throw new ServiceException("id为空，修改失败");
        }
        schoolTestProject.update();
        return toAjax(schoolTestProjectService.updateById(schoolTestProject));
    }

    /**
     * 删除测试项目
     */
    @Log(title = "examination", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable List<Long> ids)
    {
        return toAjax(schoolTestProjectService.removeByIds(ids));
    }

    /**
     * 本次考试下所能选择的测试项目
     * */
    @GetMapping("/getProjectList/{examId}")
    public TableDataInfo getProjectList(@PathVariable Long examId,SchoolTestProject schoolTestProject)
    {
        return getDataTable(schoolTestProjectService.getProjectList(examId,schoolTestProject));
    }
}
