package yangtz.cs.liu.campus.controller.examination;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.SecurityUtils;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.recruit.SchoolRecruitStudent;
import yangtz.cs.liu.campus.service.recruit.ISchoolRecruitStudentService;
import yangtz.cs.liu.campus.vo.recruit.RecruitAndEduStudentVo;
import yangtz.cs.liu.campus.vo.recruit.RecruitEduStudentVo;
import yangtz.cs.liu.campus.vo.recruit.SchoolRecruitStudentExportVo;

/**
 * @author xuten
 */
@RestController
@RequestMapping("/recruitStudent")
public class SchoolRecruitStudentController extends BaseController {
    @Autowired
    private ISchoolRecruitStudentService recruitStudentService;

    /**教务管理-考生账号-修改页面
     * 考生信息查看
     * 获取学生
     * */
    @GetMapping("/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable Long id)
    {
        //return AjaxResult.success(recruitStudentService.getInfo(id));
        return AjaxResult.success(recruitStudentService.getById(id));
    }

    /**教务管理-信息审核-修改页面
     * 考生信息查看
     * 获取学生
     * */
    @GetMapping("/getStuInfo/{id}/{examId}")
    public AjaxResult getStuInfo(@PathVariable Long id, @PathVariable Long examId)
    {
        return AjaxResult.success(recruitStudentService.getStuInfo(id,examId));
    }


    /**教务管理-信息审核-修改页面
     * 点击保存按钮，实现对已提交报名的学生信息进行修改
     * 需修改考生与考试关系的身份证号字段
     * */
    @PutMapping("/edit/{examId}")
    public AjaxResult edit(@PathVariable Long examId,@RequestBody RecruitAndEduStudentVo student)
    {
        if(StringUtils.isNull(student.getId())){
            throw new ServiceException("id为空,请检查");
        }
        return toAjax(recruitStudentService.editRecruitAndEdu(examId, student));
    }

    /**
     * 教务管理-信息审核-导出报名信息
     * 导出全部报名信息或按条件模糊查询的信息
     * */
    @PostMapping("/export/{examId}")
    public void export(HttpServletResponse response, RecruitEduStudentVo vo, @PathVariable Long examId) {
        List<SchoolRecruitStudentExportVo> list = new ArrayList<>();
        ExcelUtil<SchoolRecruitStudentExportVo> util = new ExcelUtil<>(
            SchoolRecruitStudentExportVo.class);
        vo.setExamId(examId);
        List<RecruitEduStudentVo> voList = recruitStudentService.getInfoCheck(vo);
        //获取所有studentId
        if(StringUtils.isNotNull(voList) && voList.size() > 0){
            List<Long> idList = voList.stream().map(RecruitEduStudentVo::getStudentId).distinct().collect(Collectors.toList());
            if(StringUtils.isNotNull(idList) && idList.size() > 0){
                 list = recruitStudentService.editExport(idList,examId);
                 util.exportExcel(response, list, "学生报名信息表");
            }else {
                util.exportExcel(response, list, "学生报名信息表");
            }
        }
        util.exportExcel(response, list, "学生报名信息表");
    }

    /**
     * 考务管理-考生账号管理-列表
     * */
    @GetMapping("/list")
    public TableDataInfo list(SchoolRecruitStudent student) {
        startPage();
        return getDataTable(recruitStudentService.queryList(student));
    }

    /**考务管理-考生账号管理-重置密码*/
    @PutMapping("/resetPwd")
    public AjaxResult resetPwd(@RequestBody SchoolRecruitStudent student)
    {
       if(StringUtils.isNull(student.getId())){
           throw new ServiceException("id为空");
       }
        student.setPassword(SecurityUtils.encryptPassword(student.getPassword()));
        student.update();
        return toAjax(recruitStudentService.updateById(student));
    }


}
