package yangtz.cs.liu.campus.controller.examination;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.domain.recruit.SchoolRecruitRelation;
import yangtz.cs.liu.campus.service.recruit.ISchoolRecruitRelationService;

/**
 * @author xuten
 */
@RestController
@RequestMapping("/recruit-relation")
public class SchoolRecruitRelationController extends BaseController {

  @Autowired
  private ISchoolRecruitRelationService recruitRelationService;

  /**
   * 考场分配/成绩管理-查看
   */
  @GetMapping("/getAddressInfo/{id}")
  public AjaxResult getAddressInfo(@PathVariable Long id) {
    return AjaxResult.success(recruitRelationService.getAddressInfo(id));
  }

  /**
   * 考场分配/成绩管理-修改
   */
  @PutMapping("/edit")
  public AjaxResult edit(@RequestBody SchoolRecruitRelation relation) {
    if (StringUtils.isNull(relation.getId())) {
      throw new ServiceException("id为空,请检查");
    }
    if (relation.getExamTime().contains("：")) {
      String t = relation.getExamTime();
      t = t.replace("：", ":");
      relation.setExamTime(t);
    }
    relation.update();
    return toAjax(recruitRelationService.updateById(relation));
  }


}
