package yangtz.cs.liu.campus.controller.examination;

import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.recruit.SchoolRecruitProject;
import yangtz.cs.liu.campus.service.recruit.ISchoolRecruitProjectService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 测试项目Controller
 *
 * @author wengxiulin
 * @date 2023-04-11
 */
@RestController
@RequestMapping("/schoolRecruitProject")
public class SchoolRecruitProjectController extends BaseController
{
    @Autowired
    private ISchoolRecruitProjectService schoolRecruitProjectService;

    /**
     * 查询测试项目列表
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolRecruitProject schoolRecruitProject)
    {
//        startPage();
        List<SchoolRecruitProject> list = schoolRecruitProjectService.selectSchoolRecruitProjectList(schoolRecruitProject);
        return getDataTable(list);
    }

    /**
     * 导出测试项目列表
     */
    @Log(title = "examination", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SchoolRecruitProject schoolRecruitProject)
    {
        List<SchoolRecruitProject> list = schoolRecruitProjectService.selectSchoolRecruitProjectList(schoolRecruitProject);
        ExcelUtil<SchoolRecruitProject> util = new ExcelUtil<SchoolRecruitProject>(SchoolRecruitProject.class);
        util.exportExcel(response, list, "examination数据");
    }

    /**
     * 获取测试项目详细信息
     */
    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(schoolRecruitProjectService.getById(id));
    }

    /**
     * 新增测试项目
     */
    @Log(title = "examination", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolRecruitProject schoolRecruitProject)
    {
        schoolRecruitProject.insert();
        return toAjax(schoolRecruitProjectService.save(schoolRecruitProject));
    }

    /**
     * 修改测试项目
     */
    @Log(title = "examination", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolRecruitProject schoolRecruitProject)
    {
        if (StringUtils.isNull(schoolRecruitProject.getId())){
            throw new ServiceException("id为空，修改失败");
        }
        schoolRecruitProject.update();
        return toAjax(schoolRecruitProjectService.updateById(schoolRecruitProject));
    }

    /**
     * 删除测试项目
     */
    @Log(title = "examination", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable List<Long> ids)
    {
        return toAjax(schoolRecruitProjectService.removeByIds(ids));
    }

    /**
     * 本次考试下所能选择的测试项目
     * */
    @GetMapping("/getProjectList/{examId}")
    public TableDataInfo getProjectList(@PathVariable Long examId,SchoolRecruitProject schoolRecruitProject)
    {
        return getDataTable(schoolRecruitProjectService.getProjectList(examId,schoolRecruitProject));
    }
}
