package yangtz.cs.liu.campus.controller.examination;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.campus.domain.examination.JuniorHighSchool;
import yangtz.cs.liu.campus.service.examination.IJuniorHighSchoolService;

/**
 * 初中学校Controller
 * 
 * @author wengxiulin
 * @date 2023-04-11
 */
@RestController
@RequestMapping("/juniorHighSchool")
public class JuniorHighSchoolController extends BaseController
{
    @Autowired
    private IJuniorHighSchoolService juniorHighSchoolService;

    /**
     * 查询初中学校列表
     */
    @GetMapping("/list")
    public TableDataInfo list(JuniorHighSchool juniorHighSchool)
    {
//        startPage();
        List<JuniorHighSchool> list = juniorHighSchoolService.selectJuniorHighSchoolList(juniorHighSchool);
        return getDataTable(list);
    }

    /**
     * 导出初中学校列表
     */
    @Log(title = "初中学校", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, JuniorHighSchool juniorHighSchool)
    {
        List<JuniorHighSchool> list = juniorHighSchoolService.selectJuniorHighSchoolList(juniorHighSchool);
        ExcelUtil<JuniorHighSchool> util = new ExcelUtil<JuniorHighSchool>(JuniorHighSchool.class);
        util.exportExcel(response, list, "初中学校数据");
    }

    /**
     * 获取初中学校详细信息
     */
    @GetMapping(value = "/getInfo/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(juniorHighSchoolService.getById(id));
    }

    /**
     * 新增初中学校
     */
    @Log(title = "初中学校", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    public AjaxResult add(@RequestBody JuniorHighSchool juniorHighSchool)
    {
        juniorHighSchool.insert();
        return toAjax(juniorHighSchoolService.save(juniorHighSchool));
    }

    /**
     * 修改初中学校
     */
    @Log(title = "初中学校", businessType = BusinessType.UPDATE)
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody JuniorHighSchool juniorHighSchool)
    {
        if (StringUtils.isNull(juniorHighSchool.getId())){
            throw new ServiceException("id为空，修改失败");
        }
        juniorHighSchool.update();
        return toAjax(juniorHighSchoolService.updateById(juniorHighSchool));
    }

    /**
     * 删除初中学校
     */
    @Log(title = "初中学校", businessType = BusinessType.DELETE)
	@DeleteMapping("/delete/{ids}")
    public AjaxResult remove(@PathVariable List<Long> ids)
    {
        return toAjax(juniorHighSchoolService.removeByIds(ids));
    }
}
