package yangtz.cs.liu.campus.controller.examination;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.service.examination.IEduArtStudentService;
import yangtz.cs.liu.campus.service.recruit.IEduRecruitStudentService;
import yangtz.cs.liu.campus.vo.examination.EduCruitStudentExportVo;
import yangtz.cs.liu.campus.vo.examination.EduExportVo;

/**
 * @author xuten
 */
@RestController
@RequestMapping("/edu-recruit-student")
public class EduRecruitStudentController extends BaseController {

    @Autowired
    private IEduArtStudentService eduArtStudentService;
    @Autowired
    private IEduRecruitStudentService eduRecruitStudentService;

    /**
     * 教育局艺考生信息导入模板下载
     * */
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response) {
        ExcelUtil<EduCruitStudentExportVo> util = new ExcelUtil<EduCruitStudentExportVo>(EduCruitStudentExportVo.class);
        util.importTemplateExcel(response, "导入信息模板");
    }

    /**
     * 教育局艺考生信息导入
     * */
    @PostMapping("/importData/{examId}")
    public AjaxResult importDate(@PathVariable Long examId, MultipartFile file) throws Exception {
        ExcelUtil<EduCruitStudentExportVo> util = new ExcelUtil<>(EduCruitStudentExportVo.class);
        List<EduCruitStudentExportVo> list = util.importExcel(file.getInputStream());

        //校验数据
        eduRecruitStudentService.checkImport(list);
        //数据导入
        return AjaxResult.success(eduRecruitStudentService.importData(list,examId));
    }
}
