package yangtz.cs.liu.campus.controller.examination;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import yangtz.cs.liu.campus.domain.examination.EduArtStudent;
import yangtz.cs.liu.campus.service.examination.IEduArtStudentService;
import yangtz.cs.liu.campus.vo.examination.EduExportVo;
import yangtz.cs.liu.campus.vo.student.SchoolStudentVO;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * @author xuten
 */
@RestController
@RequestMapping("/eduArtStudent")
public class EduArtStudentController extends BaseController {

    @Autowired
    private IEduArtStudentService eduArtStudentService;

    /**
     * 教育局艺考生信息导入模板下载
     * */
    @PostMapping("/importTemplate")
    public void importTemplate(HttpServletResponse response) {
        ExcelUtil<EduExportVo> util = new ExcelUtil<EduExportVo>(EduExportVo.class);
        util.importTemplateExcel(response, "导入教育局信息模板");
    }

    /**
     * 教育局艺考生信息导入
     * */
    @PostMapping("/importData/{examId}")
    public AjaxResult importDate(@PathVariable Long examId, MultipartFile file) throws Exception {
        ExcelUtil<EduExportVo> util = new ExcelUtil<>(EduExportVo.class);
        List<EduExportVo> list = util.importExcel(file.getInputStream());

        //校验数据
        eduArtStudentService.checkImport(list);
        //数据导入
        return AjaxResult.success(eduArtStudentService.importData(list,examId));
    }
}
