package yangtz.cs.liu.campus.controller.exam;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.exam.*;
import yangtz.cs.liu.campus.service.exam.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

/**
 * 问卷调查controller
 */
@RestController
@RequestMapping("/examMain")
public class ExamMainController extends BaseController {

    @Autowired
    private IExamMainService examMainService;

    private Logger log = LoggerFactory.getLogger(ExamMainController.class);

    /**
     * 查询问卷调查列表
     *
     * @param examMain
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(ExamMain examMain) {
        try {
            startPage();
            List<ExamMain> list = examMainService.queryList(examMain);
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("查询问卷调查活动时出现异常");
        }
    }

    /**
     * 新增
     *
     * @param examMain
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated ExamMain examMain) {
        return toAjax(examMainService.save(examMain));
    }

    /**
     * 修改
     *
     * @param examMain
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated ExamMain examMain) {
        if (StringUtils.isNull(examMain.getId())) {
            throw new BaseException("主键id不能为空");
        }
        return toAjax(examMainService.updateById(examMain));
    }


    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Integer> ids) {
        try {
            return toAjax(examMainService.deleteByIds(ids));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("删除时出现异常");
        }
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<ExamMain> list = examMainService.listByIds(ids);
        ExcelUtil<ExamMain> util = new ExcelUtil<>(ExamMain.class);
        util.exportExcel(response, list, "问卷调查活动表");
    }

    //导出全部
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, ExamMain examMain) {
        LambdaQueryWrapper<ExamMain> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(isNotBlank(examMain.getExamName()), ExamMain::getExamName, examMain.getExamName())
                .eq(isNotBlank(examMain.getState()), ExamMain::getState, examMain.getState())
                .orderByDesc(ExamMain::getCreateTime)
        ;
        List<ExamMain> list = examMainService.list(lqw);
        ExcelUtil<ExamMain> util = new ExcelUtil<>(ExamMain.class);
        util.exportExcel(response, list, "问卷调查活动表");
    }


    /**
     * 撤回问卷调查
     *
     * @param id
     * @return
     */
    @GetMapping("/recallExam/{id}")
    public AjaxResult recallExam(@PathVariable Long id) {
        return AjaxResult.success(examMainService.editExamState('0', id));
    }


    /**
     * 发布问卷活动
     *
     * @param id
     * @return
     */
    @GetMapping("/publishExam/{id}")
    public AjaxResult publishExam(@PathVariable Long id) {
        examMainService.checkExam(id);
        return AjaxResult.success(examMainService.editExamState('1', id));
    }


    /**
     * 结束问卷调查
     *
     * @param id
     * @return
     */
    @GetMapping("/finishExam/{id}")
    public AjaxResult finishExam(@PathVariable Long id) {
        return AjaxResult.success(examMainService.editExamState('2', id));
    }


}
