package yangtz.cs.liu.campus.controller.epidemic;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.exception.base.BaseException;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.epidemic.EpidemicMain;
import yangtz.cs.liu.campus.domain.exam.ExamMain;
import yangtz.cs.liu.campus.service.epidemic.IEpidemicMainService;
import yangtz.cs.liu.campus.service.exam.IExamMainService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

import static com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank;

/**
 * 问卷调查controller
 */
@RestController
@RequestMapping("/epidemicMain")
public class EpidemicMainController extends BaseController {

    @Autowired
    private IEpidemicMainService epidemicMainService;

    private Logger log = LoggerFactory.getLogger(EpidemicMainController.class);

    /**
     * 查询问卷调查列表
     *
     * @param epidemicMain
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(EpidemicMain epidemicMain) {
        try {
            startPage();
            List<EpidemicMain> list = epidemicMainService.queryList(epidemicMain);
            return getDataTable(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("查询问卷调查活动时出现异常");
        }
    }

    /**
     * 新增
     *
     * @param epidemicMain
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated EpidemicMain epidemicMain) {
        return toAjax(epidemicMainService.save(epidemicMain));
    }

    /**
     * 修改
     *
     * @param epidemicMain
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated EpidemicMain epidemicMain) {
        if (StringUtils.isNull(epidemicMain.getId())) {
            throw new BaseException("主键id不能为空");
        }
        return toAjax(epidemicMainService.updateById(epidemicMain));
    }


    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping("/delete/{ids}")
    @Transactional(rollbackFor = Exception.class)
    public AjaxResult delete(@PathVariable("ids") List<Integer> ids) {
        try {
            return toAjax(epidemicMainService.deleteByIds(ids));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ServiceException("删除时出现异常");
        }
    }

    /**
     * 导出
     *
     * @param ids
     * @return
     */
    @PostMapping("/export/{ids}")
    public void export(HttpServletResponse response, @PathVariable("ids") List<Integer> ids) {
        List<EpidemicMain> list = epidemicMainService.listByIds(ids);
        ExcelUtil<EpidemicMain> util = new ExcelUtil<>(EpidemicMain.class);
        util.exportExcel(response, list, "问卷调查活动表");
    }

    //导出全部
    @PostMapping("/export")
    public void exportAll(HttpServletResponse response, EpidemicMain epidemicMain) {
        LambdaQueryWrapper<EpidemicMain> lqw = new LambdaQueryWrapper<>();
        lqw
                .like(isNotBlank(epidemicMain.getEpidemicName()), EpidemicMain::getEpidemicName, epidemicMain.getEpidemicName())
                .eq(isNotBlank(epidemicMain.getState()), EpidemicMain::getState, epidemicMain.getState())
                .orderByDesc(EpidemicMain::getCreateTime)
        ;
        List<EpidemicMain> list = epidemicMainService.list(lqw);
        ExcelUtil<EpidemicMain> util = new ExcelUtil<>(EpidemicMain.class);
        util.exportExcel(response, list, "问卷调查活动表");
    }


    /**
     * 撤回问卷调查
     *
     * @param id
     * @return
     */
    @GetMapping("/recallEpidemic/{id}")
    public AjaxResult recallExam(@PathVariable Long id) {
        return AjaxResult.success(epidemicMainService.editEpidemicState('0', id));
    }


    /**
     * 发布问卷活动
     *
     * @param id
     * @return
     */
    @GetMapping("/publishEpidemic/{id}")
    public AjaxResult publishEpidemic(@PathVariable Long id) {
        epidemicMainService.checkEpidemic(id);
        return AjaxResult.success(epidemicMainService.editEpidemicState('1', id));
    }


    /**
     * 结束问卷调查
     *
     * @param id
     * @return
     */
    @GetMapping("/finishEpidemic/{id}")
    public AjaxResult finishEpidemic(@PathVariable Long id) {
        return AjaxResult.success(epidemicMainService.editEpidemicState('2', id));
    }


}
