package yangtz.cs.liu.campus.controller.educationalStatistics;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import cn.hutool.core.io.resource.ClassPathResource;
import com.core.utils.StringUtil;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.service.educationStatistics.IEducationStatisticsService;
import yangtz.cs.liu.campus.util.TemplateExcelUtils;
import yangtz.cs.liu.campus.vo.educationStatistics.ExportClassVo;
import yangtz.cs.liu.campus.vo.educationStatistics.StatisticsAgeVo;
import yangtz.cs.liu.campus.vo.educationStatistics.StatisticsClassVo;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/statistics")
public class StatisticsController extends BaseController {
    @Autowired
    private IEducationStatisticsService statisticsService;

    /**
     * 查询班级信息
     */

    @GetMapping("/class/{schoolYear}")
    public TableDataInfo classList(@PathVariable("schoolYear") int schoolYear)
    {
        return getDataTable(statisticsService.getClassNum(schoolYear));
    }

    /**班级导出*/
    @PostMapping("/exportClass/{schoolYear}")
    public void exportClass(@PathVariable("schoolYear") int schoolYear, HttpServletResponse response)
    {
        List<StatisticsClassVo> list = statisticsService.getClassNum(schoolYear);
        if(StringUtils.isNull(list) || list.size() == 0){
            throw new ServiceException(schoolYear+"学年没有任何班级");
        }
        //处理数据
        List<ExportClassVo> voList = new ArrayList<>();
        //List<String> gradeNameList=list.stream().map(StatisticsClassVo::getGradeName).collect(Collectors.toList());
        //获取年级名并去重
        List<String> gradeNameList=list.stream().map(StatisticsClassVo::getGradeName).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
        for(String gradeName : gradeNameList){
            ExportClassVo vo = new ExportClassVo();
            vo.setGradeName(gradeName);
            List<StatisticsClassVo> vos = new ArrayList<>();
            //获取年级名一样的对象
            for(StatisticsClassVo classVo : list){
                if(gradeName.equals(classVo.getGradeName())){
                    vos.add(classVo);
                }
            }
            vo.setList(vos);
            voList.add(vo);
        }
        try {

            ClassPathResource classPathResource = new ClassPathResource("template/countClass.xlsx");
            //获取模板文件绝对路径
            String absolutePath = classPathResource.getAbsolutePath();

            TemplateExportParams params = new TemplateExportParams(TemplateExcelUtils.convertTemplatePath("template/countClass.xlsx"));

            Map<String, Object> finalMap = new HashMap<String, Object>();
            finalMap.put("classList",voList);
            finalMap.put("schoolYear",schoolYear);

            Workbook workbook = ExcelExportUtil.exportExcel(params, finalMap);

            workbook.write(response.getOutputStream());

        } catch (Exception e) {
            throw new ServiceException("下载出错");
        }
    }

    /**
     * 教务-统计-年龄统计
     */
    @GetMapping("/age/{schoolYear}")
    public TableDataInfo age(@PathVariable("schoolYear") String schoolYear)
    {
        if (StringUtils.isEmpty(schoolYear)){
            throw new ServiceException("请选择学年!");
        }
        return getDataTable(statisticsService.getAgeNum(Integer.parseInt(schoolYear)));
    }

    /**年龄导出*/
    @PostMapping("/exportAge/{schoolYear}")
    public void exportAge(@PathVariable("schoolYear") int schoolYear,HttpServletResponse response)
    {
        List<StatisticsAgeVo> list = statisticsService.getAgeNum(schoolYear);
        try {
            TemplateExportParams params = new TemplateExportParams(TemplateExcelUtils.convertTemplatePath("template/countAge.xlsx"));
            Map<String, Object> finalMap = new HashMap<String, Object>();
            finalMap.put("ageList",list);
            Workbook workbook = ExcelExportUtil.exportExcel(params, finalMap);
            workbook.write(response.getOutputStream());
        } catch (Exception e) {
            throw new ServiceException("下载出错");
        }
    }
}
