package yangtz.cs.liu.campus.controller.device;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.activiti.service.IProcessService;
import yangtz.cs.liu.campus.domain.device.SchoolDeviceClaim;
import yangtz.cs.liu.campus.domain.vehicle.SchoolVehicleApplication;
import yangtz.cs.liu.campus.service.device.ISchoolDeviceClaimService;
import yangtz.cs.liu.campus.service.device.ISchoolDeviceService;
import yangtz.cs.liu.campus.vo.device.ClaimListVo;
import yangtz.cs.liu.campus.vo.device.ClaimTodoVo;
import static com.core.constant.ProcessCommon.ROLEKEY;
import static com.core.constant.ProcessDefinition.DEVICECLAIM;
import static com.core.constant.ProcessDefinition.VEHICLEAPPLICATION;
import static yangtz.cs.liu.campus.constant.ProcessState.PASS;
import static yangtz.cs.liu.campus.constant.ProcessState.REFUSE;

/**
 * 设备领用Controller
 *
 * @author ruoyi
 * @date 2022-10-16
 */
@RestController
@RequestMapping("/deviceClaim")
public class SchoolDeviceClaimController extends BaseController
{
    @Autowired
    private ISchoolDeviceClaimService schoolDeviceClaimService;
    @Autowired
    private ISchoolDeviceService schoolDeviceService;
    @Autowired
    private IProcessService processService;

    @ApiOperation("列表查询")
    @GetMapping("/list")
    public TableDataInfo list(String submitState,ClaimListVo claimListVo)
    {
        startPage();
        List<ClaimListVo> list = schoolDeviceClaimService.queryList(submitState,claimListVo);
//        List<SchoolDeviceClaim> list = schoolDeviceClaimService.queryList(schoolDeviceClaim);
        return getDataTable(list);
    }

    /**
     * 获取设备领用详细信息
     */
    @ApiOperation("id查询")
    @GetMapping("/queryById/{id}")
    public AjaxResult queryById(@PathVariable("id") Long id)
    {
//        SchoolDeviceClaim schoolDeviceClaim = schoolDeviceClaimService.getById(id);
//        ClaimListVo entity = new ClaimListVo();
//        BeanUtils.copyProperties(schoolDeviceClaim,entity);
//        String deviceName = schoolDeviceService.getById(schoolDeviceClaim.getDeviceId()).getDeviceName();
//        entity.setDeviceName(deviceName);
        return AjaxResult.success(schoolDeviceClaimService.getInfo(id));
    }

    /**
     * 新增设备领用申请
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolDeviceClaim schoolDeviceClaim)
    {
        schoolDeviceClaim.setType("deviceClaim");
        //schoolDeviceClaim.setTeacherId(getUserId());
        //schoolDeviceClaim.setTeacherName(getUsername());
        return toAjax(schoolDeviceClaimService.save(schoolDeviceClaim));
    }

    /**
     * 修改申请
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolDeviceClaim schoolDeviceClaim) {
        if(StringUtils.isNull(schoolDeviceClaim.getId())){
            throw new ServiceException("更新失败,id不能为空");
        }
        return toAjax(schoolDeviceClaimService.updateById(schoolDeviceClaim));
    }

    /**
     * 删除申请
     */
    @ApiOperation("删除")
    @DeleteMapping("/deleteByIds/{ids}")
    public AjaxResult remove(@PathVariable List<Long> ids)
    {
        return toAjax(schoolDeviceClaimService.removeByIds(ids));
    }

    /**
     * 提交申请
     */
    @PostMapping("/submitApply/{id}")
    public AjaxResult submitApply(@PathVariable("id") Long id) {
        SchoolDeviceClaim schoolDeviceClaim = schoolDeviceClaimService.getById(id);
        if (StringUtils.isNull(schoolDeviceClaim)) {
            throw new ServiceException("提交申请失败,未查询到相关信息");
        }
        String userName = getUsername();
        schoolDeviceClaim.setApplyUser(userName);
        schoolDeviceClaim.setApplyTime(DateUtils.getNowDate());
        //设置流程角色组标识
        Map<String, Object> map = new HashMap<>();
        map.put(ROLEKEY, schoolDeviceClaim.getRoleKey());
        return toAjax(schoolDeviceClaimService.submitApply(schoolDeviceClaim, userName,DEVICECLAIM,map));
    }



//    /**
//     * 我的待办列表
//     * @return
//     */
//    @ApiOperation("我的待办列表")
//    @GetMapping("/taskList")
//    public TableDataInfo taskList(SchoolDeviceClaim entity) {
//        startPage();
//        String userId = getUserId().toString();
//        List<ClaimTodoVo> list = schoolDeviceClaimService.findTodoTasks(DEVICECLAIM, entity,userId);
//        return getDataTable(list);
//    }

    /**
     * 我的待办列表
     */
    @GetMapping("/myTaskList")
    public TableDataInfo myTaskList(SchoolDeviceClaim entity) {
        String userId = getUserId().toString();
        List<ClaimTodoVo> list = schoolDeviceClaimService.findMyTodoTasks(DEVICECLAIM, entity, userId);
        return getDataTable(list);
    }

    /**
     * 组待办事项列表
     */
    @GetMapping("/taskList")
    public TableDataInfo taskList(SchoolDeviceClaim entity) {
        String userId = getUserId().toString();
        List<ClaimTodoVo> list = schoolDeviceClaimService.findTodoTasks(DEVICECLAIM, entity, userId);
        return getDataTable(list);
    }

    /**
     * 完成任务
     */
    @PostMapping("/complete/{taskId}/{instanceId}")
    public AjaxResult complete(@PathVariable("taskId") String taskId, @PathVariable("instanceId") String instanceId, @RequestBody Map<String, Object> variables) {
        processService.completeTask(taskId, instanceId, variables);
        LambdaQueryWrapper<SchoolDeviceClaim> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolDeviceClaim::getInstanceId, instanceId);
        SchoolDeviceClaim claim = schoolDeviceClaimService.getOne(lqw);
        if((boolean)variables.get("pass")){
            claim.setState(PASS);
        }else {
            claim.setState(REFUSE);
        }
        schoolDeviceClaimService.updateById(claim);
        return AjaxResult.success();
    }

    /**
     * 我的已办列表
     * @param entity
     * @return
     */
    @ApiOperation("我的已办列表")
    @GetMapping("/taskDoneList")
    public TableDataInfo taskDoneList(SchoolDeviceClaim entity) {
        String userId = getUserId().toString();
        List<ClaimTodoVo> list = schoolDeviceClaimService.findDoneTasks(DEVICECLAIM, entity, userId);
        int total = processService.getDoneTotal(DEVICECLAIM, userId);
        return getTaskTable(list,total);
    }

}
