package yangtz.cs.liu.campus.controller.conference;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.conference.SchoolConference;
import yangtz.cs.liu.campus.domain.conference.SchoolConferenceDetails;
import yangtz.cs.liu.campus.service.conference.ISchoolConferenceDetailsService;
import yangtz.cs.liu.campus.service.conference.ISchoolConferenceService;
import yangtz.cs.liu.campus.vo.conference.ConferenceDetailsVO;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/schoolConferenceDetails")
public class SchoolConferenceDetailsController extends BaseController {

    @Autowired
    private ISchoolConferenceDetailsService schoolConferenceDetailsService;

    /**
     * 弹窗，选择参会人
     *
     * @author lyric
     * @date 2022/10/21 21:04
     */
    @GetMapping("/getAllUsers/{conferenceId}")
    public TableDataInfo getAllUsers(@PathVariable("conferenceId") Long conferenceId, SysUser user) {
        startPage();
        //必须传参不然切面编程获取参数为空指针
        List<ConferenceDetailsVO> allUsers = schoolConferenceDetailsService.getAllUsers(conferenceId, user);
        return getDataTable(allUsers);
    }

    /**
     * 将所选用户添加到参会人列表
     */
    @PostMapping("/join/{conferenceId}/{ids}")
    public AjaxResult join(@PathVariable("conferenceId") Long conferenceId, @PathVariable("ids") List<Long> ids) {
//        ArrayList<SchoolConferenceDetails> totalInfoList = new ArrayList<>();
//        for (int i = 0; i < ids.size(); i++) {
//            SchoolConferenceDetails temp = new SchoolConferenceDetails();
//            temp.setConferenceId(conferenceId);
//            temp.setUserId(Long.valueOf(ids.get(i).toString()));
//            totalInfoList.add(temp);
//        }
        return toAjax(schoolConferenceDetailsService.addUsers(conferenceId,ids));
    }

    /**
     * 删除
     */
    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable List<Long> ids) {
        LambdaQueryWrapper<SchoolConferenceDetails> lqw = new LambdaQueryWrapper<>();
        lqw.in(SchoolConferenceDetails::getId,ids);
        return toAjax(schoolConferenceDetailsService.remove(lqw));
    }

    /**
     * 本次参会人列表,以及选择参会人列表
     */
    @GetMapping("/list/{conferenceId}")
    public TableDataInfo list(@PathVariable Long conferenceId, ConferenceDetailsVO detailsVO) {
        detailsVO.setConferenceId(conferenceId);
        startPage();
        List<ConferenceDetailsVO> list = schoolConferenceDetailsService.queryList(detailsVO);
        return getDataTable(list);
    }
}
