package yangtz.cs.liu.campus.controller.area;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.exception.ServiceException;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import yangtz.cs.liu.activiti.service.IProcessService;
import yangtz.cs.liu.campus.domain.area.SchoolAreaApply;
import yangtz.cs.liu.campus.service.area.ISchoolAreaApplyService;
import yangtz.cs.liu.campus.service.area.ISchoolAreaDetailService;
import yangtz.cs.liu.campus.service.area.ISchoolAreaService;
import yangtz.cs.liu.campus.vo.area.AreaApplyTodoVo;
import yangtz.cs.liu.campus.vo.area.AreaApplyVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import static com.core.constant.ProcessCommon.ROLEKEY;
import static com.core.constant.ProcessDefinition.AREAAPPLY;
import static yangtz.cs.liu.campus.constant.ProcessState.PASS;
import static yangtz.cs.liu.campus.constant.ProcessState.REFUSE;

/**
 * 学校场地申请Controller
 *
 * @author ruoyi
 * @date 2022-09-29
 */
@Api(tags = "场地申请管理")
@RestController
@RequestMapping("/areaApply")
public class SchoolAreaApplyController extends BaseController
{
    @Autowired
    private ISchoolAreaApplyService schoolAreaApplyService;
    @Autowired
    private IProcessService processService;
    @Autowired
    private ISchoolAreaService schoolAreaService;
    @Autowired
    private ISchoolAreaDetailService schoolAreaDetailService;

    /**
     * 查询学校场地申请列表
     */
    @ApiOperation("列表查询")
    @GetMapping("/list")
    public TableDataInfo list(String submitState, SchoolAreaApply schoolAreaApply)
    {
        startPage();
        List<AreaApplyVo> list = schoolAreaApplyService.queryList(submitState,schoolAreaApply);
        return getDataTable(list);
    }

    /**
     * 获取场地申请详细信息
     */
    @ApiOperation("id查询")
    @GetMapping("/queryById/{id}")
    public AjaxResult queryById(@PathVariable("id") Long id)
    {
//        SchoolAreaApply schoolAreaApply = schoolAreaApplyService.getById(id);
//        //AreaApplyByIdVo entity = new AreaApplyByIdVo();
//        AreaApplyVo entity = new AreaApplyVo();
//        String areaName = schoolAreaService.getById(schoolAreaApply.getAreaId()).getAreaName();
//        String areaNo = schoolAreaDetailService.getById(schoolAreaApply.getDetailId()).getAreaNo();
//        BeanUtils.copyProperties(schoolAreaApply,entity);
//        entity.setAreaName(areaName);
//        entity.setAreaNo(areaNo);
        return AjaxResult.success(schoolAreaApplyService.getInfo(id));
    }

    /**
     * 新增学校场地申请
     *
     * @param schoolAreaApply 学校场地申请
     * @return 结果
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody @Validated SchoolAreaApply schoolAreaApply)
    {
        schoolAreaApply.setType("areaApply");
        schoolAreaApply.setTeacherId(getUserId()); //申请人
        schoolAreaApply.setTeacherName(getUsername()); //申请人
        return toAjax(schoolAreaApplyService.save(schoolAreaApply));
    }

    /**
     * 提交申请
     */
    @PostMapping("/submitApply/{id}")
    public AjaxResult submitApply(@PathVariable("id") Long id) {
        SchoolAreaApply schoolAreaApply = schoolAreaApplyService.getById(id);
        if (StringUtils.isNull(schoolAreaApply)) {
            throw new ServiceException("提交申请失败,未查询到相关信息");
        }
        String userName = getUsername();
        schoolAreaApply.setApplyUser(userName);
        schoolAreaApply.setApplyTime(DateUtils.getNowDate());
        //设置流程角色组标识
        Map<String, Object> map = new HashMap<>();
        map.put(ROLEKEY, schoolAreaApply.getRoleKey());
        return toAjax(schoolAreaApplyService.submitApply(schoolAreaApply, userName, AREAAPPLY, map));
    }

    /**
     * 修改场地申请
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody @Validated SchoolAreaApply schoolAreaApply) {
        if (StringUtils.isNull(schoolAreaApply.getId())) {
            throw new ServiceException("id为空，修改失败");
        }
        return toAjax(schoolAreaApplyService.updateById(schoolAreaApply));
    }

    /**
     * 删除学校场地申请
     */
    @ApiOperation("删除")
    @DeleteMapping("/deleteByIds/{ids}")
    public AjaxResult remove(@PathVariable List<Long> ids)
    {
        return toAjax(schoolAreaApplyService.removeByIds(ids));
    }


//    /**
//     * 我的待办列表
//     * @return
//     */
//    @ApiOperation("我的待办列表")
//    @GetMapping("/taskList")
//    public TableDataInfo taskList(SchoolAreaApply entity) {
//        startPage();
//        String userId = getUserId().toString();
//        List<AreaApplyTodoVo> list = schoolAreaApplyService.findTodoTasks(AREAAPPLY, entity,userId);
//        return getDataTable(list);
//    }

    /**
     * 我的待办列表
     * @return
     */
    @ApiOperation("我的待办列表")
    @GetMapping("/myTaskList")
    public TableDataInfo myTaskList(SchoolAreaApply entity) {
        String userId = getUserId().toString();
        List<AreaApplyTodoVo> list = schoolAreaApplyService.findMyTodoTasks(AREAAPPLY, entity, userId);
        return getDataTable(list);
    }

    /**
     * 组待办事项列表
     */
    @GetMapping("/taskList")
    public TableDataInfo taskList(SchoolAreaApply entity) {
        String userId = getUserId().toString();
        List<AreaApplyTodoVo> list = schoolAreaApplyService.findTodoTasks(AREAAPPLY, entity, userId);
        return getDataTable(list);
    }

    /**
     * 完成任务
     */
    @PostMapping("/complete/{taskId}/{instanceId}")
    public AjaxResult complete(@PathVariable("taskId") String taskId, @PathVariable("instanceId") String instanceId, @RequestBody Map<String, Object> variables) {
        processService.completeTask(taskId, instanceId, variables);
        LambdaQueryWrapper<SchoolAreaApply> lqw = new LambdaQueryWrapper<>();
        lqw.eq(SchoolAreaApply::getInstanceId,instanceId);
        SchoolAreaApply areaApply = schoolAreaApplyService.getOne(lqw);
        if((boolean)variables.get("pass")){
            areaApply.setState(PASS);
        }else {
            areaApply.setState(REFUSE);
        }
        schoolAreaApplyService.updateById(areaApply);
        return AjaxResult.success("任务完成成功");
    }

    /**
     * 我的已办列表
     * @param entity
     * @return
     */
    @ApiOperation("我的已办列表")
    @GetMapping("/taskDoneList")
    public TableDataInfo taskDoneList(SchoolAreaApply entity) {
        String userId = getUserId().toString();
        List<AreaApplyTodoVo> list = schoolAreaApplyService.findDoneTasks(AREAAPPLY, entity, userId);
        int total = processService.getDoneTotal(AREAAPPLY, userId);
        return getTaskTable(list,total);
    }


}
