package yangtz.cs.liu.campus.controller.SchoolEquipment;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import yangtz.cs.liu.campus.service.schoolEquipment.IOutStockService;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolOutStockVo;

/**
 * 设备出库
 */

@RestController
@RequestMapping("/outStock")
public class OutStockController extends BaseController {

    @Autowired
    private IOutStockService outStockService;

    /**
     * 查看设备出库列表
     * @param schoolOutStockVo
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolOutStockVo schoolOutStockVo){
        startPage();
        return getDataTable(outStockService.selectSchoolOutStockVoList(schoolOutStockVo));
    }

    /**
     * 查看设备出库详细信息
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id){
        return AjaxResult.success(outStockService.selectSchoolOutStockVoById(id));
    }
}
