package yangtz.cs.liu.campus.controller.SchoolEquipment;

import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import yangtz.cs.liu.campus.domain.schoolEquipment.SchoolEquipmentRepair;
import yangtz.cs.liu.campus.service.schoolEquipment.IEquipmentRepairService;
import yangtz.cs.liu.campus.vo.schoolEquipment.SchoolEquipmentRepairVo;

/**
 * 设备报修
 */

@RestController
@RequestMapping("/equipmentRepair")
public class EquipmentRepairController extends BaseController {

    @Autowired
    private IEquipmentRepairService equipmentRepairService;

    /**
     * 查看设备报修列表
     * @param schoolEquipmentRepairVo
     * @return
     */
    @GetMapping("/list")
    public TableDataInfo list(SchoolEquipmentRepairVo schoolEquipmentRepairVo){
        startPage();
        return getDataTable(equipmentRepairService.selectSchoolEquipmentRepairVoList(schoolEquipmentRepairVo));
    }

    /**
     * 查看设备报修详细信息
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id){
        return AjaxResult.success(equipmentRepairService.selectSchoolEquipmentRepairVoById(id));
    }

    /**
     * 新增设备报修
     * @return
     */
    @PostMapping("/add")
    public AjaxResult add(@RequestBody SchoolEquipmentRepair schoolEquipmentRepair){
        return toAjax(equipmentRepairService.insertSchoolEquipmentRepairVo(schoolEquipmentRepair));
    }

    /**
     * 修改设备报修
     * @param schoolEquipmentRepair
     * @return
     */
    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody SchoolEquipmentRepair schoolEquipmentRepair){
        return toAjax(equipmentRepairService.updateSchoolEquipmentRepair(schoolEquipmentRepair));
    }

    /**
     * 删除设备报修
     * @param ids
     * @return
     */
    @PostMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids){
        return toAjax(equipmentRepairService.deleteSchoolEquipmentRepairById(ids));
    }

    /**
     * 根据自编码获取设备信息
     * @param encode
     * @return
     */
    @GetMapping("/getEquipment/{encode}")
    public AjaxResult getEquipment(@PathVariable("encode") String encode){
        return AjaxResult.success(equipmentRepairService.getEquipment(encode));
    }

    /**
     * 获取修理人下拉框
     * @return
     */
    @GetMapping("/getRepair")
    public AjaxResult getRepair(){
        return AjaxResult.success(equipmentRepairService.getRepair());
    }
}
