/**
 * @param fun 执行函数
 * @param wait 间隔时间, 默认为 1000毫秒
 * @description 主要用在提交数据，以及模糊查询的搜索和重置按钮上面
 * */
function Throttle() {
  var prev = Date.now();  // 获取当前时间戳
  return function (fun, wait = 500) {
    var now = Date.now();
    if (now - prev > wait) {
      fun();
      prev = Date.now();
    }
  }
}

export const throttle = Throttle();
