/**
 *格式化时间
 *yyyy-MM-dd hh:mm:ss
 */
const REGEX = /(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2})/
export function formatDate(val, format) {
  if (val) {
    /**
     * @instructions 如果不是时间戳格式，且含有字符 '-' 则将 '-' 替换成 '/' && 删除小数点及后面的数字
     * @reason 将 '-' 替换成 '/' && 删除小数点及后面的数字 的原因是safari浏览器仅支持 '/' 隔开的时间格式
     */
    if (val.toString().indexOf('-') > 0) {
      val = val.replace(/T/g, ' ').replace(/\.[\d]{3}Z/, '').replace(/(-)/g, '/') // 将 '-' 替换成 '/'
      val = val.slice(0, val.indexOf('.')) // 删除小数点及后面的数字
    }
    const date = new Date(val)
    date.setHours(date.getHours() + 8)
    // eslint-disable-next-line no-unused-vars
    const [whole, yy, MM, dd, hh, mm, ss] = date.toISOString().match(REGEX)
    if (format) {
      return format
        .replace('yyyy', yy)
        .replace('yy', yy.slice(2))
        .replace('MM', MM)
        .replace('dd', dd)
        .replace('hh', hh)
        .replace('mm', mm)
        .replace('ss', ss)
    } else {
      return [yy, MM, dd].join('-') + ' ' + [hh, mm, ss].join(':')
    }
  } else {
    return '--'
  }
}

/*
 * 隐藏用户手机号中间四位
 */
export function hidePhone(phone) {
  if (phone !== null && phone !== undefined) {
    return phone.replace(/(\d{3})\d{4}(\d{4})/, '$1****$2')
  }
}

export function hideIdCard(idCard) {
  if (idCard !== null && idCard !== undefined) {
    const pat = /(\d{0})\d*(\d{4})/
    return idCard.replace(pat, '$1***********$2')
  } else {
    return ''
  }
}

export function hideName(str) {
  if (str !== null && str !== undefined) {
    if (str.length <= 3) {
      return '*' + str.substring(1, str.length)
    } else if (str.length > 3 && str.length <= 6) {
      return '**' + str.substring(2, str.length)
    } else if (str.length > 6) {
      return str.substring(0, 2) + '****' + str.substring(6, str.length)
    }
  } else {
    return ''
  }
}

// 货币过滤器
export function moneyFormat(val, str) {
  // str  规定 货币类型
  if (!val) return '0.00'
  let value = parseFloat(val).toFixed(2)// 提前保留两位小数
  const intPart = Number(value) - Number(value) % 1
  const intPartFormat = intPart.toString().replace(/(\d)(?=(?:\d{3})+$)/g, '$1,') // 将整数部分逢三一断 ？？？
  let floatPart = '.00' // 预定义小数部分
  value = value.toString()// 将number类型转为字符串类型，方便操作
  const value2Array = value.split('.')
  if (value2Array.length === 2) { // =2表示数据有小数位
    floatPart = value2Array[1].toString() // 拿到小数部分
    if (floatPart.length === 1) { // 补0,实际上用不着
      return str + intPartFormat + '.' + floatPart + '0'
    } else {
      return str + intPartFormat + '.' + floatPart
    }
  } else {
    return str + intPartFormat + floatPart
  }
}

// 通过id 获取对应name
export function getLabel(value, key, labelKey, arr) {
  if (arr.length > 0) {
    const label = arr.find(item => {
      return item[key].toString() === value.toString()
    })
    return label[labelKey]
  }
}

export function moneyToBig(money) {
  // 汉字的数字
  var cnNums = ['零', '壹', '贰', '叁', '肆', '伍', '陆', '柒', '捌', '玖']
  // 基本单位
  var cnIntRadice = ['', '拾', '佰', '仟']
  // 对应整数部分扩展单位
  var cnIntUnits = ['', '万', '亿', '兆']
  // 对应小数部分单位
  var cnDecUnits = ['角', '分', '毫', '厘']
  // 整数金额时后面跟的字符
  var cnInteger = '整'
  // 整型完以后的单位
  var cnIntLast = '元'
  // 最大处理的数字
  var maxNum = 999999999999999.9999
  // 金额整数部分
  var integerNum
  // 金额小数部分
  var decimalNum
  // 输出的中文金额字符串
  var chineseStr = ''
  // 分离金额后用的数组，预定义
  var parts
  // 传入的参数为空情况
  if (money === '') {
    return ''
  }
  money = parseFloat(money)
  if (money >= maxNum) {
    return ''
  }
  // 传入的参数为0情况
  if (money === 0) {
    chineseStr = cnNums[0] + cnIntLast + cnInteger
    return chineseStr
  }
  // 转为字符串
  money = money.toString()
  // indexOf 检测某字符在字符串中首次出现的位置 返回索引值（从0 开始） -1 代表无
  if (money.indexOf('.') === -1) {
    integerNum = money
    decimalNum = ''
  } else {
    parts = money.split('.')
    integerNum = parts[0]
    decimalNum = parts[1].substr(0, 4)
  }
  // 转换整数部分
  if (parseInt(integerNum, 10) > 0) {
    let zeroCount = 0
    const IntLen = integerNum.length
    for (let i = 0; i < IntLen; i++) {
      const n = integerNum.substr(i, 1)
      const p = IntLen - i - 1
      const q = p / 4
      const m = p % 4
      if (n === '0') {
        zeroCount++
      } else {
        if (zeroCount > 0) {
          chineseStr += cnNums[0]
        }
        zeroCount = 0
        chineseStr += cnNums[parseInt(n)] + cnIntRadice[m]
      }
      if (m === 0 && zeroCount < 4) {
        chineseStr += cnIntUnits[q]
      }
    }
    // 最后+ 元
    chineseStr += cnIntLast
  }
  // 转换小数部分
  if (decimalNum !== '') {
    const decLen = decimalNum.length
    for (let i = 0; i < decLen; i++) {
      const n = decimalNum.substr(i, 1)
      if (n !== '0') {
        chineseStr += cnNums[Number(n)] + cnDecUnits[i]
      }
    }
  }
  if (chineseStr === '') {
    chineseStr += cnNums[0] + cnIntLast + cnInteger
  } else if (decimalNum === '') {
    chineseStr += cnInteger
  }

  return chineseStr
}

export function getSimpleText(html, str) {
  const re1 = new RegExp('<.+?>', 'g') // 匹配html标签的正则表达式，"g"是搜索匹配多个符合的内容
  const arrEntities = { 'lt': '<', 'gt': '>', 'nbsp': ' ', 'amp': '&', 'quot': '"', 'ldquo': '“', 'mdash': '—', 'rdquo': '”' }
  const result = html.replace(re1, '').replace(/&(lt|gt|nbsp|amp|quot|ldquo|mdash|rdquo);/ig, function(all, t) {
    return arrEntities[t] || str
  })
  return result || str
}
