import Layout from '@/layout'

export default [
  {
    path: '/gradeWork',
    component: Layout,
    hidden: true,
    permissions: ['childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index'],
    children: [
      {
        path: 'studentManage/parentInfo',
        component: () => import('@/views/smartSchool/gradeWork/studentManage/parentInfo'),
        name: 'gradeWork_parentInfo',
        meta: {
          title: '家长信息'
        }
      },
      {
        path: 'studentManage/score',
        component: () => import('@/views/smartSchool/gradeWork/studentManage/score'),
        name: 'grade_score',
        meta: {
          title: '学生积分'
        }
      },
      {
        path: 'classView/parentInfo',
        component: () => import('@/views/smartSchool/gradeWork/classView/parentInfo'),
        name: 'classView_parentInfo',
        meta: {
          title: '家长信息'
        }
      },
    ]
  },
  {
    path: '/gradeWork',
    component: Layout,
    hidden: true,
    permissions: ['childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index'],
    children: [
      {
        path: 'parentsInfoPush/receiveList',
        component: () => import('@/views/smartSchool/gradeWork/parentsInfoPush/receiveList'),
        name: 'gradeWork_receiveList',
        meta: {
          title: '接收人列表'
        }
      }
    ]
  },


  // 月度考勤详细信息
  {
    path: '/gradeWork/clockmanage/monedit',
    component: Layout,
    hidden: true,
    permissions: ['childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index'],
    children: [
      {
        path: '',
        component: () => import('@/views/smartSchool/gradeWork/clockManage/monthClock/editmonthClock.vue'),
        name: 'GradeWorkClockManageMonthClock',
        meta: {
          title: '月度考勤详细信息'
        }
      }
    ]
  },

  {
    // 信息发布--数据
    path: '/gradeWork/infoPublish/dataList',
    component: Layout,
    hidden: true,
    permissions: ['childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index'],
    children: [
      {
        path: '',
        component: () => import('@/views/smartSchool/gradeWork/infoPublish/dataList/index.vue'),
        name: 'DataList',
        meta: {
          title: '数据'
        }
      }
    ]
  },

  {
    // 信息发布--数据查看
    path: '/gradeWork/infoPublish/dataView',
    component: Layout,
    hidden: true,
    permissions: ['childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index'],
    children: [
      {
        path: '',
        component: () => import('@/views/smartSchool/gradeWork/infoPublish/dataView/index.vue'),
        name: 'DataView',
        meta: {
          title: '数据查看'
        }
      }
    ]
  },

  //调查问卷模块
  {
    path: '/gradeQuestion',
    component: Layout,
    hidden: true,
    permissions: ['question:child:check'],
    children: [
      {
        path: "content/:examId",
        component: () => import('@/views/smartSchool/gradeWork/questionnaireManagement/QuestionnaireContent'),
        name: 'GradeQuestionContent',
        meta: {
          title: '问卷内容'
        }
      },
      {
        path: 'result/:examId',
        component: () => import('@/views/smartSchool/gradeWork/questionnaireManagement/ActivityResult'),
        name: 'gradeQuestionResult',
        meta: {
          title: '问卷结果'
        }
      },
    ]
  }


]
