import Layout from "@/layout";

export default [
  {
    path: "/classAdviser",
    component: Layout,
    hidden: true,
    permissions: ["system:user:edit"],
    children: [
      /**班级查看模块*/
      {
        path: "classView/parentInfo",
        component: () =>
          import("@/views/smartSchool/classAdviser/classView/stuParents"),
        name: "classViewStuParents",
        meta: {
          title: "家长信息",
        },
      },
      /**学生管理模块*/
      {
        path: "studentManage/parentsInfo",
        component: () =>
          import("@/views/smartSchool/classAdviser/studentManage/parentsInfo"),
        name: "classAdviser_parentsInfo",
        meta: {
          title: "家长信息",
        },
      },
      {
        path: "studentManage/score",
        component: () =>
          import("@/views/smartSchool/classAdviser/studentManage/score"),
        name: "classAdviser_score",
        meta: {
          title: "学生积分",
        },
      },
      {
        path: "studentManage/studentCommendation",
        component: () =>
          import(
            "@/views/smartSchool/classAdviser/studentManage/studentCommendation"
          ),
        name: "classAdviser_studentCommendation",
        meta: {
          title: "学生嘉奖",
        },
      },
      {
        path: "studentManage/discipline",
        component: () =>
          import("@/views/smartSchool/classAdviser/studentManage/discipline"),
        name: "classAdviser_discipline",
        meta: {
          title: "学生违纪",
        },
      },
    ],
  },

  {
    path: "/classAdviser/classManage/teacherList",
    component: Layout,
    hidden: true,
    permissions: [
      "childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index",
    ],
    children: [
      {
        path: "",
        component: () =>
          import("@/views/smartSchool/classAdviser/classManage/teacherList"),
        name: "classAdviser_teacherList",
        meta: {
          title: "任课教师",
        },
      },
    ],
  },

  //教师工作家长信息
  // {
  //   path: '/classInfo',
  //   component: Layout,
  //   hidden: true,
  //   permissions: ['childrenHealth:earlyChildhoodSyndrome:archivesManagement:birthday:index'],
  //   children: [
  //     {
  //       path: 'teacherList',
  //       component: () => import('@/views/smartSchool/classInfo/teacherList'),
  //       name: 'teacherList',
  //       meta: {
  //         title: '老师列表'
  //       }
  //     }
  //   ]
  // },

  //调查问卷模块

  {
    path: "/classAdviserQuestion",
    component: Layout,
    hidden: true,
    permissions: ["question:child:check"],
    children: [
      {
        path: "content/:examId",
        component: () =>
          import(
            "@/views/smartSchool/classAdviser/questionnaireManagement/components/QuestionnaireContent"
          ),
        name: "ClassAdviserQuestionnaireContent",
        meta: {
          title: "问卷内容",
        },
      },
      {
        path: "result/:examId",
        component: () =>
          import(
            "@/views/smartSchool/classAdviser/questionnaireManagement/components/ActivityResult"
          ),
        name: "ActivityResult",
        meta: {
          title: "问卷结果",
        },
      },
    ],
  },
];
