import request from '@/utils/request'

// 查询学校每日食谱列表
export function listRecipes(query) {
  return request({
    url: '/system/recipes/list',
    method: 'get',
    params: query
  })
}

// 查询学校每日食谱详细
export function getRecipes(id) {
  return request({
    url: '/system/recipes/' + id,
    method: 'get'
  })
}

// 新增学校每日食谱
export function addRecipes(data) {
  return request({
    url: '/system/recipes',
    method: 'post',
    data: data
  })
}

// 修改学校每日食谱
export function updateRecipes(data) {
  return request({
    url: '/system/recipes',
    method: 'put',
    data: data
  })
}

// 删除学校每日食谱
export function delRecipes(id) {
  return request({
    url: '/system/recipes/' + id,
    method: 'delete'
  })
}
