import request from "@/utils/request"

/**
 * @description 车辆管理-用车申请 接口
 */

// 列表查询
export function getInfoList(queryParams) {
  return request({
    url: '/vehicleApplication/list',
    method: 'get',
    params: queryParams
  })
}

// 添加
export function addInfo(postForm) {
  return request({
    url: '/vehicleApplication/add',
    method: 'post',
    data: postForm
  })
}

// 修改
export function editInfo(postForm) {
  return request({
    url: '/vehicleApplication/edit',
    method: 'put',
    data: postForm
  })
}

// 删除
export function deleteInfo(ids) {
  return request({
    url: '/vehicleApplication/delete/' + ids,
    method: 'delete'
  })
}

// 根据主键查询详情
export function getInfo(id) {
  return request({
    url: '/vehicleApplication/getInfo/' + id,
    method: 'get',
  })
}

// 提交申请
export function submitApply(id) {
  return request({
    url: '/vehicleApplication/submitApply/' + id,
    method: 'post',
  })
}

// 待办事项列表(组任务)
export function taskList() {
  return request({
    url: '/vehicleApplication/taskList',
    method: 'get',
  })
}

// 完成任务
export function complete({ taskId, instanceId, comment, pass }) {
  return request({
    url: `/vehicleApplication/complete/${ taskId }/${ instanceId }`,
    method: 'post',
    data: {
      comment,
      pass
    }
  })
}

// 我的已办列表
export function taskDoneList() {
  return request({
    url: '/vehicleApplication/taskDoneList',
    method: 'get',
  })
}

/* 查看流程图 */
export function read(instanceId) {
  return request({
    url: '/activiti/process/read-resource',
    method: 'get',
    params: {
      pProcessInstanceId: instanceId
    }
  })
}

// 可选车辆信息
export function getVehicleList(queryParams) {
  return request({
    url: '/vehicle/licensePlateList',
    method: 'get',
    params: queryParams
  })
}

/* 我的任务(待办) */
export function getMyTaskList(queryParams) {
  return request({
    url: '/vehicleApplication/myTaskList',
    method: 'get',
    params: queryParams
  })
}

/* 我的已办任务 */
export function getTaskDoneList(queryParams) {
  return request({
    url: '/vehicleApplication/taskDoneList',
    method: 'get',
    params: queryParams
  })
}
