import request from '@/utils/request'

// 查询教师履历
export function listResume(query) {
  return request({
    url: '/school/teacherResume/list',
    method: 'get',
    params: query
  })
}

//
// 查询教师履历queryOne
export function getOneResume(id) {
  return request({
    url: '/school/teacherResume/queryOne/' + id,
    method: 'get',
  })
}

// 新增教师履历
export function addResume(data) {
  return request({
    url: '/school/teacherResume/add',
    method: 'post',
    data: data
  })
}

// 修改教师履历
export function editResume(data) {
  return request({
    url: '/school/teacherResume/edit',
    method: 'put',
    data: data
  })
}

// 删除教师履历
export function deleteResume(ids) {
  return request({
    url: '/school/teacherResume/delete/' + ids,
    method: 'delete',
  })
}
