import request from "@/utils/request";

// 添加任务
export function addTeacherNotice(data) {
  return request({
    url: "/teacherFiles/notice",
    method: "post",
    data: data,
  });
}

// 任务列表
export function listTeacherNotice(query) {
  return request({
    url: "/teacherFiles/notice/list",
    method: "get",
    params: query,
  });
}

// 任务详情
export function infoTeaNotice(id) {
  return request({
    url: `/teacherFiles/notice/${id}`,
    method: "put",
  });
}

// 任务修改
export function updateTask(data) {
  return request({
    url: "/teacherFiles/notice",
    method: "put",
    data: data,
  });
}

// 发布任务
export function infoTeacherNotice(id) {
  return request({
    url: `/teacherFiles/notice/release/${id}`,
    method: "put",
  });
}

// 任务撤回
export function taskRetracted(id) {
  return request({
    url: "/teacherFiles/notice/withdraw/" + id,
    method: "put",
  });
}

// 任务完成
export function taskCompleted(id) {
  return request({
    url: "/teacherFiles/notice/complete/" + id,
    method: "put",
  });
}

// 任务删除
export function delTaskInfo(id) {
  return request({
    url: "/teacherFiles/notice/" + id,
    method: "delete",
  });
}

// 通知下档案查看|数据维护
export function getteacherNotice(query) {
  return request({
    url: "/teacherFiles/files/list",
    method: "get",
    params: query,
  });
}
// 级部列表
export function getGradeTnfo(query) {
  return request({
    url: '/teacherFiles/files/gradeList',
    method: 'get',
    params: query
  })
}
//老师查看详情
export function getNoticeInfo(query) {
  return request({
    url: "/teacherFiles/files/list",
    method: "get",
    params: query,
  });
}

//老师查看列表
export function getTeacherTnfo(query) {
  return request({
    url: `/teacherFiles/files/getTeachList`,
    // url: `/teacherFiles/files/getTeachList/${userId}`,
      method: 'get',
      params:query
  })
}

//级部查看档案详情
export function getDepInfo(query) {
  return request({
    url: "/teacherFiles/files/list",
    method: "get",
    params: query,
  });
}
//查看档案详情
export function getFileTnfo(id) {
  return request({
    url: "/teacherFiles/files/" + id,
    method: "get",
  });
}
// //查看档案详情
// export function getFileTnfo(query) {
//   return request({
//     url: "/teacherFiles/files",
//       method: "get",
//       params: query,
//   });
// }
// 同步档案
export function syncNotice(id) {
  return request({
    url: "/teacherFiles/files/synchronous/" + id,
    method: "put",
  });
}

// 教师档案修改
export function updateInfo(data) {
  return request({
    url: "/teacherFiles/files",
    method: "put",
    data: data,
  });
}

// 教师档案删除
export function delInfo(id) {
  return request({
    url: "/teacherFiles/files/" + id,
    method: "delete",
  });
}

// 教师档案提交审核
// /teacherFiles/files/submitTo/29
export function fileSubReview(id) {
  return request({
    url: `/teacherFiles/files/submitTo/${id}`,
    method: "put",
  });
}

// 教师档案驳回
export function fileSubApproved(id) {
  return request({
    url: `/teacherFiles/files/reject/${id}`,
    method: "put",
  });
}
// 教师档案提交
export function fileSubRejected(id) {
  return request({
    url: `/teacherFiles/files/passThrough/${id}`,
    method: "put",
  });
}


//查看可添加老师列表
export function getTeaList(tId) {
  return request({
    url: `/teacherFiles/files/getTeacherRocer/${tId}`  ,
      method: "get",
  });
}

//添加老师
export function addTeachaer(ids) {
  return request({
    url: '/teacherFiles/files/teacherAdd/' +ids,
      method: "get",
  });
}

// 导出
export function exportList(id) {
    return request({
        url: '/teacherFiles/notice/export/' + id,
        method: 'get',
    })
}
