import request from '@/utils/request'

// 查询学生列表
export function listStudent(queryParams) {
  return request({
    url: '/school/student/list',
    method: 'get',
    params: queryParams
  })
}

// 查询学生详细
export function getStudent(id) {
  return request({
    url: '/school/student/queryOne/' + id,
    method: 'get'
  })
}

// 新增学生
export function addStudent(data) {
  return request({
    url: '/school/student/add',
    method: 'post',
    data: data
  })
}

// 修改学生-----
export function updateStudent(data) {
  return request({
    url: '/school/student/edit',
    method: 'put',
    data: data
  })
}

// 删除学生
export function delStudent(ids) {
  return request({
    url: 'school/student/delete/' + ids,
    method: 'delete'
  })
}

// 学生班级获取
export function getClassInfo(queryParams) {
  return request({
    url: '/school/studentClasses/list/' + queryParams.studentId,
    method: 'get',
  })
}

// 新增学生班级
export function addClass(data) {
  return request({
    url: '/school/studentClasses/add',
    method: 'post',
    data: data,
  })
}

// 查询个人班级详情
export function getClassDetailInfo(id) {
  return request({
    url: '/school/studentClasses/queryOne/' + id,
    method: 'get',
  })
}

// 修改学生班级
export function updateClass(data) {
  return request({
    url: '/school/studentClasses/edit',
    method: 'put',
    data: data,
  })
}

// 删除学生班级
export function delClass(ids) {
  return request({
    url: '/school/studentClasses/delete/' + ids,
    method: 'delete',
  })
}

// 获取学生家长信息列表
export function getParentsList(queryParams) {
  return request({
    url: '/school/studentParent/list/' + queryParams.studentId,
    method: 'get',
  })
}

// 新增学生家长
export function addParent(data) {
  return request({
    url: '/school/studentParent/add/' + data.studentId,
    method: 'post',
    data: data,
  })
}

// 修改学生家长
export function editParent(data) {
  return request({
    url: '/school/studentParent/edit/' + data.studentId,
    method: 'put',
    data: data,
  })
}

// 查询学生家长详情
export function getParentDetail(id) {
  return request({
    url: '/school/studentParent/queryOne/' + id,
    method: 'get',
  })
}

// 删除学生家长
export function delParent(ids) {
  return request({
    url: '/school/studentParent/delete/' + ids,
    method: 'delete',
  })
}

//学生照片导入
export function filesUpload(files) {
  return request({
    url: "/school/student/importStudentPicture",
    method: 'post',
    data: files,
  })
}

// 查询学生信息
export function getAllInfo(id) {
  return request({
    url: '/school/student/queryAllInfo/' + id,
    method: 'get',
  })
}

// 获取学生信息
export function getSchoolNu(id) {
  return request({
    url: '/school/student/queryAllInfo/' + id,
    method: 'get',
  })
}

export function setPermission(data) {
  return request({
    url: '/school/authority/edit',
    method: 'put',
    data
  })
}

export function getPermission() {
  return request({
    url: '/school/authority/list',
    method: 'get',
  })
}


export function getTableInfo(id) {
  return request({
    url: '/school/student/queryAllInfo/' + id,
    method: 'get',
  })
}






