import request from '@/utils/request'

//级部成员列表
export function listMentor(gradeId, query) {
  return request({
    url: '/schoolGradeMentor/list/' + gradeId,
    method: 'get',
    params: query
  })
}

// 查询单个级部成员信息
export function getMentor(id) {
  return request({
    url: '/schoolGradeMentor/queryOne/' + id,
    method: 'get'
  })
}

// 新增级部成员
export function addMentor(gradeId, data) {
  return request({
    url: '/schoolGradeMentor/add/' + gradeId,
    method: 'post',
    data: data
  })
}

// 修改级部成员
export function updateMentor(data) {
  return request({
    url: '/schoolGradeMentor/edit',
    method: 'put',
    data: data
  })
}

// 删除级部成员
export function delMentor(ids) {
  return request({
    url: '/schoolGradeMentor/remove/' + ids,
    method: 'delete'
  })
}
