import request from '@/utils/request'

// 查询列表
export function studentEvaluateList(query){
  return request({
    url: '/school/studentEvaluate/list',
    method: 'get',
    params: query
  })
}

// 新增
export function addStudentEvaluation(query){
  return request({
    url: '/school/studentEvaluate/add',
    method: 'post',
    data: query
  })
}

// 修改
export function editStudentEvaluation(query){
  return request({
    url: '/school/studentEvaluate/edit',
    method: 'put',
    data: query
  })
}

// 删除
export function deleteEvaluation(ids){
  return request({
    url: '/school/studentEvaluate/delete/' + ids,
    method: 'DELETE'
  })
}