import request from "@/utils/request";

// 查询学生成绩列表
export function listStudentAchievement(query) {
  return request({
    url: "/school/studentAchievement/list",
    method: "get",
    params: query,
  });
}
// 查询学生成绩列表个人
export function listStudentAchievementgr(query) {
  return request({
    url: "/school/studentAchievement/listGr",
    method: "get",
    params: query,
  });
}

// 查询学生成绩详细
export function getStudentAchievement(id) {
  return request({
    url: "/school/studentAchievement/" + id,
    method: "get",
  });
}

// 新增学生成绩
export function addStudentAchievement(data) {
  return request({
    url: "/school/studentAchievement",
    method: "post",
    data: data,
  });
}

// 修改学生成绩
export function updateStudentAchievement(data) {
  return request({
    url: "/school/studentAchievement",
    method: "put",
    data: data,
  });
}

// 删除学生成绩
export function delStudentAchievement(id) {
  return request({
    url: "/school/studentAchievement/" + id,
    method: "delete",
  });
}
