import request from "@/utils/request";

//查询借出归还台账列表
export function getLendingReturn(params) {
  return request({
    url: "/circulation/list",
    method: "GET",
    params,
  });
}

//借出归还台账 根据ID获取详情
export function getLRDetailByID(id) {
  return request({
    url: `/circulation/${id}`,
    method: "GET",
  });
}

//借出归还台账新增
export function addLendingReturn(data) {
  return request({
    url: "/circulation/add",
    method: "POST",
    data,
  });
}

//借出归还台账编辑
export function editLendingReturn(data) {
  return request({
    url: "/circulation/edit",
    method: "PUT",
    data,
  });
}

//借出归还台账删除
export function deleteLendingReturn(id) {
  return request({
    url: `/circulation/delete/${id}`,
    method: "POST",
  });
}



