import request from "@/utils/request";

//查询设备台账列表
export function getEquipmentLedger(params) {
  return request({
    url: "/equipmentLedger/list",
    method: "GET",
    params,
  });
}

//根据ID查看设备台账详细信息
export function getEquipmentLedgerDetailByID(id) {
  return request({
    url: `equipmentLedger/${id}`,
    method: "GET",
  });
}

//设备台账入库 新增
export function addEquipmentLedger(data) {
  return request({
    url: "/equipmentLedger/add",
    method: "POST",
    data,
  });
}

//设备台账编辑
export function editEquipmentLedger(data) {
  return request({
    url: "/equipmentLedger/edit",
    method: "PUT",
    data,
  });
}

//根据分类编码ID获取设备型号
export function getModelByID(id) {
  return request({
    url: `/productCategory/getEquipmentByCode/${id}`,
    method: "GET",
  });
}

//设备台账出库 删除
export function deleteEquipmentLedger(id) {
  return request({
    url: `/equipmentLedger/outStock/${id}`,
    method: "POST",
  });
}

/**
 * 公共接口
 * 获取用户列表
 **/
export function getUserList(params) {
  return request({
    url: "/equipmentLedger/getUser",
    method: "GET",
    params,
  });
}
//获取打印设备条码信息
export function equipmentPrint(ids) {
  return request({
    url: `/equipmentLedger/getEquipmentledger/${ids}`,
    method: "get",
  });
}
