import request from "@/utils/request";

/**
 * @description 课程管理-课程 接口
 * */

// 查询课程列表
export function getClassList(queryParams) {
  return request({
    url: '/schoolTimeTable/list',
    method: 'get',
    params: queryParams
  })
}

// 新增保存课程
export function addClass(postForm) {
  return request({
    url: '/schoolTimeTable/add',
    method: 'post',
    data: postForm
  })
}

// 查询详情
export function getDetailInfo(id) {
  return request({
    url: '/schoolTimeTable/queryOne/' + id,
    method: 'get'
  })
}

// 修改保存课程
export function editClass(postForm) {
  return request({
    url: '/schoolTimeTable/edit',
    method: 'post',
    data: postForm
  })
}

// 删除课程
export function deleteClass(ids) {
  return request({
    url: '/schoolTimeTable/delete/' + ids,
    method: 'delete'
  })
}

// 导入课程
// export function importDataSchedule(file) {
//   return request({
//     url: '/schoolTimeTable/importDataSchedule',
//     method: 'post',
//     data: file
//   })
// }
