import request from "@/utils/request";

// 新增录播室
export function addStudio(data) {
  return request({
    url: "/studio/add",
    method: "post",
    data: data,
  });
}

// 查看录播室列表
export function getStudio(query) {
  return request({
    url: "/studio/list",
    method: "get",
    params: query,
  });
}

// 修改录播室信息
export function updateStudio(id, studioName, studioStatu, studioArea) {
  const data = {
    id,
    studioName,
    studioStatu,
    studioArea,
  };
  return request({
    url: "/studio/edit",
    method: "put",
    data: data,
  });
}

// 删除礼堂预约
export function delAuditor(ids) {
  return request({
    url: "/studio/" + ids,
    method: "delete",
  });
}

// 查看录播室详情
export function listAuditor(ids) {
  return request({
    url: "/studio/" + ids,
    method: "get",
  });
}
// 修改录播室状态
export function editAuditorzt(id, studioStatu) {
  const data = {
    id,
    studioStatu,
  };
  return request({
    url: "/studio/edit",
    method: "put",
    data: data,
  });
}
