import request from "@/utils/request";

// 新增论文情况
export function addThesis(data) {
  return request({
    url: "/thesis/add",
    method: "post",
    data: data,
  });
}

// 查看论文情况列表
export function getThesis(query) {
  return request({
    url: "/thesis/list",
    method: "get",
    params: query,
  });
}

// 查看论文情况详情
export function listThesis(ids) {
  return request({
    url: "/thesis/" + ids,
    method: "get",
  });
}
// 修改论文情况
export function updateThesis(data) {
  return request({
    url: "/thesis",
    method: "put",
    data: data,
  });
}

// 删除论文情况
export function delThesis(ids) {
  return request({
    url: "/thesis/" + ids,
    method: "delete",
  });
}
