import request from "@/utils/request";

// 查询报修列表
export function listRepairs(query) {
  return request({
    url: "/repairs/list",
    method: "get",
    params: query,
  });
}

// 新增报修信息
export function addRepairs(data) {
  return request({
    url: "/repairs/add",
    method: "post",
    data: data,
  });
}
// 查询报修信息详情
export function getRepairs(id) {
  return request({
    url: "/repairs/" + id,
    method: "get",
  });
}

// 修改报修信息
export function updateRepairs(data) {
  return request({
    url: "/repairs",
    method: "put",
    data: data,
  });
}

// 删除报修信息
export function delRepairs(ids) {
  return request({
    url: "/repairs/" + ids,
    method: "delete",
  });
}

//反馈结果接口
export function submitRepairs(data) {
  return request({
    url: "/repairs",
    method: "put",
    data: data,
  });
}

//获取报修单号
export function numberRepairs(data) {
  return request({
    url: "/repairs/getNumber",
    method: "get",
    data: data,
  });
}
