import request from "@/utils/request";

// 查询礼堂预约列表
export function listAuditor(query) {
  return request({
    url: "/auditorium/listGr",
    method: "get",
    params: query,
  });
}

// 新增礼堂预约
export function addAuditor(data) {
  return request({
    url: "/auditorium/add",
    method: "post",
    data: data,
  });
}
// 查看详情
export function getAuditor(id) {
  return request({
    url: "/auditorium/" + id,
    method: "get",
  });
}

// 修改礼堂预约信息
export function updateAuditor(data) {
  return request({
    url: "/auditorium/edit",
    method: "put",
    data: data,
  });
}

// 删除礼堂预约
export function delAuditor(ids) {
  return request({
    url: "/auditorium/deleteByIds/" + ids,
    method: "delete",
  });
}

//提交礼堂预约申请
export function submitAuditor(id) {
  return request({
    url: "/auditorium/submitApply/" + id,
    method: "post",
  });
}

//获取校领导下拉框
export function getLeaderList(data) {
  return request({
    url: "/school/teacherLeave/getSchoolLeader",
    method: "get",
    params: data,
  });
}
// 附件上传
export function uploadList() {
  return request({
    url: "/common/upload",
    method: "post",
  });
}