import request from "@/utils/request";

/**
 * @description 打卡记录及月度考勤记录 接口
 * */

// 打卡记录查询列表
export function personalList(queryForm) {
  return request({
    url: "/schoolAtt/deptList",
    method: "get",
    params: queryForm
  })
}

// 月度考勤查询列表
export function personalMonList(queryForm) {
  return request({
    url: "/schoolAttMon/deptList",
    method: "get",
    params: queryForm
  })
}

// 按月初始化数据
export function initDataByMon(data) {
  return request({
    url: "/schoolAttMon/initDept",
    method: "put",
    params: data,
  })
}

// 按月批量提交
export function submitDataByMon(data) {
  return request({
    url: "/schoolAttMon/submitDept",
    method: "put",
    params: data,
  })
}

// 单个提交
export function submitDataByMonById(id) {
  return request({
    url: "/schoolAttMon/submitOne/" + id,
    method: "put",
  })
}

// 查看单条记录
export function checkRow(id) {
  return request({
    url: "/schoolAttMon/getInfo/" + id,
    method: "get",
  })
}

// 请假局部模块
// 新增
export function addRow(data, id) {
  return request({
    url: "/schoolAttEa/add/" + id,
    method: "post",
    data,
  })
}

// 查看
export function checkDeatil(id) {
  return request({
    url: "/schoolAttEa/getInfo/" + id,
    method: "get",
  })
}

// 修改
export function editRow(data) {
  return request({
    url: "/schoolAttEa/edit",
    method: "put",
    data,
  })
}

// 删除
export function delRow(id) {
  return request({
    url: "/schoolAttEa/delete/" + id,
    method: "delete",
  })
}

// 加班局部模块
// 新增
export function addRowOt(data, id) {
  return request({
    url: "/schoolAttOt/add/" + id,
    method: "post",
    data,
  })
}

// 查看
export function checkDeatilOt(id) {
  return request({
    url: "/schoolAttOt/getInfo/" + id,
    method: "get",
  })
}

// 修改
export function editRowOt(data) {
  return request({
    url: "/schoolAttOt/edit",
    method: "put",
    data,
  })
}

// 删除
export function delRowOt(id) {
  return request({
    url: "/schoolAttOt/delete/" + id,
    method: "delete",
  })
}

//获取加班时间
export function getOverTime(data) {
  return request({
    url: "/schoolAttOt/count/",
    method: "get",
    params: data
  })
}

//根据请假开始时间和结束时间，获取请假时长
export function getLeaveTime(data) {
  return request({
    url: '/school/teacherLeave/getTotalTime',
    method: 'get',
    params: data,
  })
}
