import request from '@/utils/request'

// 查询兴趣班列表
export function listClassManagement(query) {
  return request({
    url: '/interestClass/list',
    method: 'get',
    params: query
  })
}

// 查询兴趣班详细
export function getClassManagement(id) {
  return request({
    url: '/interestClass/getInfo/' + id,
    method: 'get'
  })
}

// 新增兴趣班
export function addClassManagement(data) {
  return request({
    url: '/interestClass/add',
    method: 'post',
    data: data
  })
}

// 修改兴趣班
export function updateClassManagement(data) {
  return request({
    url: '/interestClass/edit',
    method: 'put',
    data: data
  })
}

// 删除兴趣班
export function delClassManagement(id) {
  return request({
    url: '/interestClass/delete/' + id,
    method: 'delete'
  })
}
