import request from '@/utils/request'

// 查询兴趣班学生列表
export function listClassChild(query,interestClassesId) {
  return request({
    url: '/interestChild/list/' + interestClassesId,
    method: 'get',
    params: query
  })
}

// 查询兴趣班学生详细
export function getClassChild(id) {
  return request({
    url: '/interestChild/getInfo/' + id,
    method: 'get'
  })
}

// 新增兴趣班学生
export function addClassChild(data,interestClassesId) {
  return request({
    url: '/interestChild/add/' + interestClassesId,
    method: 'post',
    data: data
  })
}

// 修改兴趣班学生
export function updateClassChild(data) {
  return request({
    url: '/interestChild/edit',
    method: 'put',
    data: data
  })
}

// 删除兴趣班学生
export function delClassChild(id) {
  return request({
    url: '/interestChild/delete/' + id,
    method: 'delete'
  })
}


// 查询学生列表(区别于第一个接口)
export function listChild(query,interestClassesId) {
  return request({
    url: '/interestChild/addList/' + interestClassesId,
    method: 'get',
    params: query
  })
}
