import request from '@/utils/request'

//信息推送

//获取表格数据
export function getList(queryParams) {
  return request({
    // url: '/messageParentsPushs/list',
    url: '/messageParentsPushs/gradeList',
    method: 'get',
    params: queryParams
  })
}


// 查询详情
export function getInfoOne(id) {
  return request({
    url: '/messageParentsPushs/getInfo/' + id,
    method: 'get',
    // params: id
  })
}


//新增表格数据
export function addInfo(queryParams) {
  return request({
    url: '/messageParentsPushs/add',
    method: 'post',
    data: queryParams
  })
}

//修改表格数据
export function editInfo(queryParams) {
  return request({
    url: '/messageParentsPushs/edit',
    method: 'put',
    data: queryParams
  })
}

//删除表格数据
export function deleteInfo(ids) {
  return request({
    url: '/messageParentsPushs/delete/' + ids,
    method: 'delete',
    data: ids
  })
}

//导出表格选中行数据
export function exportPart(ids) {
  return request({
    url: '/messageParentsPushs/export/' + ids,
    method: 'post',
    data: ids
  })
}

//导出表格所有数据
export function exportFull() {
  return request({
    url: '/messageParentsPushs/export',
    method: 'post',
  })
}

// 修改状态
export function changeState(id, state) {
  return request({
    url: '/messageParentsPushs/changeState/' + id,
    method: 'put',
    params: {
      state
    }
  })
}
