import request from '@/utils/request'

// 公文流转
export function getDocumentFlowList(state, queryForm) {
  return request({
    url: `/schoolofficialflow/taskList/${state}`,
    method: 'get',
    params: queryForm
  })
}

//发起人
export function getInitiator(id) {
  return request({
    url: `/schoolofficialflow/review/getInfo/${id}`,
    method: 'get',
  })
}

//发起人操作 提交方法
export function initiatorSubmit(id, data) {
  console.log(23, data)
  return request({
    url: `/schoolofficialflow/initiator/${id}`,
    method: 'put',
    data: data
  })
}

//发起人操作，获取批阅人
export function getApprover(queryForm) {
  return request({
    url: `/school/teacherLeave/getSchoolLeader`,
    method: 'get',
    params: queryForm
  })
}

//发起人操作，获取传阅人
export function getCirculator(queryForm) {
  return request({
    url: `/school/teacher/getTeacherList`,
    method: 'get',
    params: queryForm
  })
}

//发起人操作，获取传阅人
export function getViewer() {
  return request({
    url: `/school/teacher/getTeacherList`,
    method: 'get',
  })
}


//批阅人操作 提交方法

export function approverSubmit(id, queryForm) {
  return request({
    url: `/schoolofficialflow/review/${id}`,
    method: 'put',
    params: queryForm
  })
}

//传阅人操作 表明信息已经收到

export function received(id) {
  return request({
    url: `/schoolofficialflow/circulator/${id}`,
    method: 'put',
  })
}

