import request from '@/utils/request'

/**
 * 首页
 * */

// 通知公告
export function getNoticeList(queryParams) {
  return request({
    url: '/schoolMessagePush/teacherMessageList',
    method: 'get',
    params: queryParams
  })
}

// 值班表
export function getDutyTableList1(queryParams) {
  return request({
    url: '/school/teacherDuty/dutyList',
    method: 'get',
    params: queryParams
  })
}
export function getDutyTableList(queryParams) {
  return request({
    url: '/duty/list',
    method: 'get',
    params: { state: 1, ...queryParams }
  })
}

// 值班表
export function getWeather() {
  return request({
    url: '/school/common/weather',
    method: 'get'
  })
}

// 日历点击事件
export function getThingListByTime(queryParams) {
  return request({
    url: '/schoolCalendarDetail/select',
    method: 'get',
    params: queryParams
  })
}

// 首页展示常用功能
export function showCommonfunctionsList() {
  return request({
    url: '/menu/function/list',
    method: 'get'
  })
}

// 常用功能列表
export function commonfunctionsList() {
  return request({
    url: '/menu/function/authMenu',
    method: 'get'
  })
}

// 添加常用功能到首页
export function addCommonFunctionsToShow(queryParams) {
  return request({
    url: '/menu/function/add',
    method: 'post',
    data: queryParams
  })
}

// 任务数量
export function getTaskNum() {
  return request({
    url: `/school/count/myCount`,
    method: 'get'
  })
}

// 任务数量
export function getDutyDetail(id, dutyType) {
  if (dutyType === '0') {
    // console.log('我是节日')
    /******************** 是hoilday还是holiday？ ********************/
    return request({
      url: `/dutyDetails/queryHoilday/${id}`,
      method: 'get'
    })
  } else {
    // console.log('我是寒暑假')
    return request({
      url: `/dutyDetails/queryVacation/${id}`,
      method: 'get'
    })
  }
}
