import request from "@/utils/request";

export function getList(queryParams, dcwjId) {
  return request({
    url: `/dcwjAn/list/${dcwjId}`,
    method: 'get',
    params: queryParams
  })
}

export function findDetail(id) {
  return request({
    url: `/dcwjAn/list/`,
    method: 'get',
  })
}

export function addAnswer(queryParams, examId) {
  return request({
    url: `/dcwjAn/add/`,
    method: 'post',
    data: { ...queryParams, dcwjId: examId }
  })
}

export function editAnswer(queryParams, examId) {
  return request({
    url: `/dcwjAn/edit/`,
    method: 'put',
    data: { ...queryParams, dcwjId: examId }
  })
}

export function delAnswer(id) {
  return request({
    url: `/dcwjAn/delete/${id}`,
    method: 'delete',
  })
}

export class BackToFrontTransfer {
  constructor(whole) {
    class RowData {
      constructor(data) {
        this.id = data.id
        ///关键部分///
        this.activityTitle = data.examName
        this.department = data.deptId
        this.deptName = data.deptName
        this.userId = data.userId
        this.name = data.name
        this.answerTime = data.answerTime
      }
    }

    console.log(whole)
    return whole.map(item => new BackToFrontTransfer(item));
  }
}

export class FrontToBackTransfer {
  constructor(data) {
    this.id = data.id
    ///关键部分///
    this.examName = data.activityTitle
    this.deptId = data.department
    this.deptName = data.deptName
    this.userId = data.userId
    this.name = data.name
    this.answerTime = data.answerTime
  }
}

// 获取统计数据
export function getCount(dcwjId) {
  return request({
    url: `/dcwjAn/getCount/${dcwjId}`,
    method: 'get',
  })
}


export function getQuestionResultQueryOne(dcwjId) {
  return request({
    url: `/dcwjAn/queryById/${dcwjId}`,
    method: 'get',
  })
}


