import request from '@/utils/request'

// 查询信息发布主表列表
export function infoList(query) {
  return request({
    url: '/school/xxfb/list',
    method: 'get',
    params: query
  })
}

// 查询信息发布主表详细
export function getInfo(id) {
  return request({
    url: '/school/xxfb/getInfo/' + id,
    method: 'get'
  })
}

// 新增信息发布主表
export function addInfo(data) {
  return request({
    url: '/school/xxfb/add',
    method: 'post',
    data: data
  })
}

// 修改信息发布主表
export function updateInfo(data) {
  return request({
    url: '/school/xxfb/edit',
    method: 'put',
    data: data
  })
}

// 删除信息发布主表
export function delInfo(id) {
  return request({
    url: '/school/xxfb/delete/' + id,
    method: 'delete'
  })
}

// 发布
export function publish(id) {
    return request({
      url: '/school/xxfb/submit/' + id,
      method: 'put'
    })
  }

// 撤回
  export function withdraw(id) {
    return request({
      url: '/school/xxfb/withdraw/' + id,
      method: 'put'
    })
  }

// 数据
export function dataList(id) {
    return request({
      url: '/school/dataList/' + id,
      method: 'get'
    })
  }

// 当前登录人所在级部树
export function gradeTree() {
    return request({
      url: '/schoolGrade/getUserGradeTree',
      method: 'get'
    })
  }

// 获取级部默认值
export function getGrade() {
    return request({
      url: '/schoolGrade/getMemberGrade ',
      method: 'get'
    })
  }
