import request from '@/utils/request'

// 获取列表
export function dataList(form, id) {
  return request({
    url: '/school/xxfb/dataList/' + id,
    method: 'get',
    params: form
  })
}

// 查询信息发布内容详细
export function getRy(id) {
  return request({
    url: '/xxfb/ry/getInfo/' + id,
    method: 'get'
  })
}

// 新增信息发布内容
export function addRy(data, xxfbId) {
  return request({
    url: '/xxfb/ry/add/' + xxfbId,
    method: 'post',
    data: data
  })
}

// 修改信息发布内容
export function updateRy(data) {
  return request({
    url: '/xxfb/ry/edit',
    method: 'put',
    data: data
  })
}



// 删除信息发布内容
export function delRy(id) {
  return request({
    url: '/xxfb/ry/delete/' + id,
    method: 'delete'
  })
}
