import request from "@/utils/request";

// 查看选课任务发布列表
export function dataCurricula(query) {
  return request({
    url: "/curricula/variable/list",
    method: "get",
    params: query,
  });
}

// 新增选课任务
export function addCurricula(data) {
  return request({
    url: "/curricula/variable/add",
    method: "post",
    data: data,
  });
}
// 修改选课任务
export function updateCurricula(data) {
  return request({
    url: "/curricula/variable/edit",
    method: "post",
    data: data,
  });
}
// 查询选课任务详细信息
export function getCurricula(id) {
  return request({
    url: "/curricula/variable/" + id,
    method: "get",
  });
}
//获取当前最新级部
export function getDept(data) {
  return request({
    url: "/curricula/variable/getNewGrade",
    method: "get",
    data: data,
  });
}

/***
 * 公共接口
 * */
//获取班级列表信息
export function classList(data) {
  return request({
    url: `/curricula/variable/selectClass?grade=${data}`,
    method: "get",
  });
}
