import request from "@/utils/request";

/**
 * 考试管理 接口
 * */

// 查询考试列表
export function getExaList(queryParams) {
  return request({
    url: '/schoolExam/list',
    method: 'get',
    params: queryParams,
  })
}

// 新增考试
export function addExamination(postForm) {
  return request({
    url: '/schoolExam/add',
    method: 'post',
    data: postForm
  })
}

// 查询详情
export function getDetailInfo(id) {
  return request({
    url: '/schoolExam/queryOne/' + id,
    method: 'get'
  })
}

// 修改考试
export function updateExamination(postForm) {
  return request({
    url: '/schoolExam/edit',
    method: 'put',
    data: postForm
  })
}

// 删除考试
export function deleteExa(ids) {
  return request({
    url: '/schoolExam/remove/' + ids,
    method: 'delete'
  })
}
// 导入考试
export function importDataSchedule(file) {
  return request({
    url: '/schoolExam/importData',
    method: 'post',
    data: file
  })
}
// 下载模板
export function examTemplate() {
  return request({
    url: '/schoolExam/importTemplate',
    method: 'get',
  })
}
// 学生成绩列表
export function scoreList(examId, query) {
  return request({
    url: '/schoolExamDetail/list/' + examId,
    method: 'get',
    params: query,
  })
}
// 查看学生成绩详情
export function scoreDetail(id) {
  return request({
    url: '/schoolExamDetail/queryOne/' + id,
    method: 'get',
  })
}
// 新增学生成绩
export function addScore(examId, data) {
  // const data={examId,data};
  return request({
    url: '/schoolExamDetail/add/' + examId,
    method: 'post',
    data: data,
  })
}
// 修改学生成绩
export function updateScore(data) {
  return request({
    url: '/schoolExamDetail/edit',
    method: 'put',
    data: data,
  })
}
// 删除学生成绩
export function delScore(id) {
  return request({
    url: '/schoolExamDetail/remove/' + id,
    method: 'delete',
  })
}

/** 初中学校管理 */
// 查询初中学校列表
export function listSchool(query) {
  return request({
    url: '/juniorHighSchool/list',
    method: 'get',
    params: query
  })
}

// 查询初中学校详细
export function getSchool(id) {
  return request({
    url: '/juniorHighSchool/getInfo/' + id,
    method: 'get'
  })
}

// 新增初中学校
export function addSchool(data) {
  return request({
    url: '/juniorHighSchool/add',
    method: 'post',
    data: data
  })
}

// 修改初中学校
export function updateSchool(data) {
  return request({
    url: '/juniorHighSchool/edit',
    method: 'put',
    data: data
  })
}

// 删除初中学校
export function delSchool(id) {
  return request({
    url: '/juniorHighSchool/delete/' + id,
    method: 'delete'
  })
}

// 测试项目
// 查询
export function listProject(query) {
  return request({
    url: '/schoolTestProject/list',
    method: 'get',
    params: query
  })
}
// 信息审核查询测试项目
export function getProjectList(examId, query) {
  return request({
    url: '/schoolTestProject/getProjectList/' + examId,
    method: 'get',
    params: query
  })
}


// 查询详细
export function getProject(id) {
  return request({
    url: '/schoolTestProject/getInfo/' + id,
    method: 'get'
  })
}

// 新增
export function addProject(data) {
  return request({
    url: '/schoolTestProject/add',
    method: 'post',
    data: data
  })
}

// 修改
export function updateProject(data) {
  return request({
    url: '/schoolTestProject/edit',
    method: 'put',
    data: data
  })
}

// 删除
export function delProject(id) {
  return request({
    url: '/schoolTestProject/' + id,
    method: 'delete'
  })
}

// 考生账号管理
// 考生账号管理查询学校艺术生信息列表
export function listStudent(query) {
  return request({
    url: '/artStudent/list',
    method: 'get',
    params: query
  })
}
// 查询账号管理详细
export function getInfo(id) {
  return request({
    url: '/artStudent/getInfo/' + id,
    method: 'get'
  })
}

// 重置密码
export function resetPwd(id, password) {
  const data = {
    id,
    password
  }
  console.log(data, 215);

  return request({
    url: '/artStudent/resetPwd',
    method: 'put',
    data: data
  })
}



// 考试管理
// 查询考试管理列表
export function listExam(query) {
  return request({
    url: '/artExam/list',
    method: 'get',
    params: query
  })
}

// 查询考试管理详细
export function getExam(id) {
  return request({
    url: '/artExam/getInfo/' + id,
    method: 'get'
  })
}

// 新增-保存
export function addExam(data) {
  return request({
    url: '/artExam/add',
    method: 'post',
    data: data
  })
}

// 新增-发布
export function addPub(data) {
  return request({
    url: '/artExam/addPub',
    method: 'post',
    data: data
  })
}
// 考试信息发布
export function editPub(data) {
  return request({
    url: '/artExam/editPub',
    method: 'put',
    data: data
  })
}
// 修改的保存
export function edit(data) {
  return request({
    url: '/artExam/edit',
    method: 'put',
    data: data
  })
}

// 修改的发布
export function updateExam(data) {
  return request({
    url: '/artExam/editPub',
    method: 'put',
    data: data
  })
}

// 删除
export function delExam(id) {
  return request({
    url: '/artExam/delete/' + id,
    method: 'delete'
  })
}
// 身份证号获取信息
export function getPerInfo(idCard) {
  return request({
    url: `/school/student/queryAllInfoByidCard/${idCard}`,
    method: 'get'
  })
}
// 报名阶段信息审核 查询
export function checkList(id, query) {
  return request({
    url: '/artExam/checkList/' + id,
    method: 'get',
    params: query
  })
}
// 报名阶段信息审核修改
export function updateRelation(id, data) {
  return request({
    url: '/artStudent/edit/' + id,
    method: 'put',
    data: data
  })
}

// 查询学校艺术生信息详细
export function getStudent(id, examId) {
  return request({
    url: '/artStudent/getStuInfo/' + id + '/' + examId,
    method: 'get',
    // data: data
  })
}
// 考场分配查询列表
export function addressList(id, query) {
  return request({
    url: '/artExam/addressList/' + id,
    method: 'get',
    params: query
  })
}
// 考场分配 成绩管理 获取详情
export function getAddressInfo(id) {
  return request({
    url: '/artRelation/getAddressInfo/' + id,
    method: 'get',
  })
}
// 考场分配 成绩管理修改
export function handleEdit(data) {
  return request({
    url: '/artRelation/edit',
    method: 'put',
    data: data
  })
}
// 考场分配发布
export function addressEnd(id) {
  return request({
    url: '/artExam/addressEnd/' + id,
    method: 'put',
    // data: data
  })
}
// *** 成绩管理查询列表
export function scoreManageList(id, query) {
  return request({
    url: '/artExam/scoreList/' + id,
    method: 'get',
    params: query
  })
}

// *** 成绩管理查发布
export function scoreEnd(id) {
  return request({
    url: '/artExam/scoreEnd/' + id,
    method: 'put',
  })
}



//导入教育局信息
export function importData(file, id) {
  return request({
    url: '/eduArtStudent/importData/' + id,
    method: 'post',
    params: file
  })
}
// 文件上传方法
export function commonUpload(file, callback = null) {
  return request({
    url: '/common/upload',
    method: 'post',
    data: file,
    onUploadProgress: progress => {
      callback && callback(progress)
    }
  })
}
// 通过
export function pass(examId, studentIds) {
  return request({
    url: `/artExam/pass/${examId}/${studentIds}`,
    method: 'put',
    // data: file,
  })
}
// 退回修改
export function back(examId, studentIds) {
  return request({
    url: `/artExam/back/${examId}/${studentIds}`,
    method: 'put',
    // data: file,
  })
}
// 驳回
export function reject(examId, studentIds) {
  return request({
    url: `/artExam/reject/${examId}/${studentIds}`,
    method: 'put',
    // data: file,
  })
}



// 单个通过
export function passOne(examId, studentIds) {
  return request({
    url: `/artExam/passOne/${examId}/${studentIds}`,
    method: 'put',
    // data: file,
  })
}
// 单个退回修改
export function backOne(examId, studentIds) {
  return request({
    url: `/artExam/backOne/${examId}/${studentIds}`,
    method: 'put',
    // data: file,
  })
}
// 单个驳回
export function rejectOne(examId, studentIds) {
  return request({
    url: `/artExam/rejectOne/${examId}/${studentIds}`,
    method: 'put',
    // data: file,
  })
}


// 结束
export function checkEnd(examId) {
  return request({
    url: `/artExam/checkEnd/${examId}`,
    method: 'put',
    // data: file,
  }).then(() => {
  })
}

