import request from "@/utils/request";

export function getList(queryParams) {
  return request({
    url: "/epidemicTasks/list", method: 'get', params: queryParams
  })
}

export {
  getList as QuestionnaireList,
  // BackToFrontTransfer as QuestionnaireTransfer
} from "../QuestionnaireContent/request"

export function scoreCandidate(reqFormData, examId) {
  return request({
    url: `/epidemicTasks/join/${ examId }`,
    method: 'post',
    data: reqFormData,
  })
}

export class BackToFrontTransfer {
  constructor(data) {
    class Single {
      constructor(data) {
        this.id = data.id
        ///关键部分///
        this.activityTitle = data.examName
        this.note = data.remark
        this.status = data.state
        this.startTime = data.startTime
        this.endTime = data.endTime
        ///关键部分结束///
        this.optionScope = data.optionScope
        this.isLeaderExam = data.isLeaderExam
      }
    }

    return data.rows.map(item => new Single(item))
  }
}

// export class QuizFrontTransfer {
//   constructor(data) {
//     class Single {
//       constructor(data) {
//         function QuizOptions(data) {
//           const AllOptions = [..."ABCDEFGH"]
//           let finalRes = []
//           AllOptions.forEach(el => {
//             finalRes.push({
//               label: el,
//               value: data[`score${el}`],
//               optionCont: data[`option${el}`],
//               show: Boolean(data[`option${el}`])
//             })
//           })
//           return finalRes
//         }
//
//         this.id = data.id
//         this.quizTitle = data.subjectTitle
//         this.quizOptionsArr = QuizOptions(data)
//         this.userAnswer = data.subjectType==="1"?null:[]
//         delete data.subjectTitle
//         return {...data, ...this}
//       }
//     }
//
//     return data.rows.map(item => new Single(item))
//
//   }
// }

export class QuizFrontTransfer {
  constructor(data) {
    class Single {
      constructor(data) {
        function QuizOptions(data) {
          const AllOptions = [..."ABCDEFGH"]
          let finalRes = []
          AllOptions.forEach(el => {
            finalRes.push({
              label: el,
              value: data[`score${ el }`],
              show: Boolean(data[`option${ el }`])
            })
          })
          return finalRes
        }

        this.id = data.id
        this.quizTitle = data.subjectTitle
        this.quizOptionsArr = QuizOptions(data)
        this.userAnswer = null
        delete data.subjectTitle
        return { ...data, ...this }
      }
    }

    class OptionsStatsObj {
      constructor(data) {
        const AllOptions = [..."ABCDEFGH"]
        let finalOptions = []
        AllOptions.forEach(el => {
          finalOptions.push({
            mark: el, isAvailable: Boolean(data[`option${ el }`]),
          })
        })
        return finalOptions
      }
    }

    return {
      data: data.rows.map(item => new Single(item)),
      option: data.rows.map(item => new OptionsStatsObj(item)),
    }
  }
}
